/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.editor;

import com.fusesource.rider.commons.ui.Menus;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.EditorMessages;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.provider.generated.AddNodeMenuFactory;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import java.util.List;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditorContributionItem
extends ContributionItem {
    public void fill(Menu menu, int index) {
        Menu subMenu;
        super.fill(menu, index);
        String label = EditorMessages.camelMenuLabel;
        MenuItem subMenuItem = Menus.getMenuItemByText((Menu)menu, (String)label);
        if (subMenuItem == null) {
            subMenuItem = new MenuItem(menu, 64);
            subMenuItem.setText(label);
        }
        if ((subMenu = subMenuItem.getMenu()) == null) {
            subMenu = new Menu(menu);
            subMenuItem.setMenu(subMenu);
        }
        final Menu theMenu = subMenu;
        subMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                EditorContributionItem.this.recreateMenu(theMenu);
            }
        });
    }

    private void recreateMenu(Menu routeMenu) {
        Menus.disposeItems((Menu)routeMenu);
        final RiderDesignEditor editor = Activator.getDiagramEditor();
        MenuItem addRouteItem = new MenuItem(routeMenu, 8);
        addRouteItem.setText(EditorMessages.addRouteCommandLabel);
        addRouteItem.setImage(Activator.getDefault().getImage("editor/add.png"));
        addRouteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                editor.addNewRoute();
                editor.fireModelChanged();
                editor.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem deleteRouteItem = new MenuItem(routeMenu, 8);
        deleteRouteItem.setText(EditorMessages.deleteRouteCommandLabel);
        deleteRouteItem.setImage(Activator.getDefault().getImage("editor/delete.gif"));
        deleteRouteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                editor.deleteRoute();
                if (editor.getModel().getChildren().size() < 1) {
                    editor.addNewRoute();
                    editor.getEditor().recreateDesignPage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new MenuItem(routeMenu, 2);
        MenuItem addMenuItem = new MenuItem(routeMenu, 64);
        addMenuItem.setText(EditorMessages.camelMenuAddLabel);
        Menu addMenu = new Menu(addMenuItem);
        addMenuItem.setMenu(addMenu);
        AddNodeMenuFactory factory = new AddNodeMenuFactory();
        factory.fillMenu(editor, addMenu);
        RouteContainer model = editor.getModel();
        if (model != null) {
            RouteSupport selectedRoute = editor.getSelectedRoute();
            List children = model.getChildren();
            int counter = 0;
            if (!children.isEmpty()) {
                new MenuItem(routeMenu, 2);
            }
            for (AbstractNode node : children) {
                if (!(node instanceof RouteSupport)) continue;
                RouteSupport route = (RouteSupport)node;
                MenuItem menuItem = new MenuItem(routeMenu, 16);
                String id = route.getId();
                if (Strings.isBlank((String)id)) {
                    id = "" + (counter + 1);
                }
                menuItem.setText("Route: " + id);
                menuItem.setImage(Activator.getDefault().getImage("route16.png"));
                final int routeIndex = counter;
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        editor.setSelectedRouteIndex(routeIndex);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                if (route == selectedRoute) {
                    menuItem.setSelection(true);
                }
                ++counter;
            }
        }
    }
}

