/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.editor;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Flow;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class LayoutHelper {
    private static final int ROUTE_MAX_HEIGHT = 50;
    protected static final int ROUTE_MAX_WIDTH = 300;
    private static final int ROUTE_HEIGHT_PADDING = 150;
    protected static final int ROUTE_WIDTH_PADDING = 250;
    protected static final int MINIMUM_CANVAS_HEIGHT = 350;
    protected static final int MINIMUM_CANVAS_WIDTH = 400;
    protected int defaultNodeWidth;
    protected int defaultNodeHeight;
    protected int defaultRouteDepth;
    protected int defaultNodeOffset;
    protected int defaultRouteOffset;
    protected int defaultRouteWidthMargin;
    protected int defaultRouteHeightMargin;
    private LayoutAlgorithm layout;
    private final RouteContainer model;
    private final Set<AbstractNode> nodes;
    private LayoutEntity[] entities;
    private LayoutRelationship[] relations;
    private double x;
    private double y;
    private int width;
    private int height;
    private boolean asynchronous;
    private boolean continuous;
    private Map<AbstractNode, LayoutEntity> map;
    private boolean horizontal;

    public static void layout(RouteContainer model, Point size) {
        if (size.x < 400) {
            size.x = 400;
        }
        if (size.y < 350) {
            size.y = 350;
        }
        int heightIncrease = 0;
        int i = 0;
        while (i < 7) {
            if (heightIncrease > 0) {
                size.x = (int)((double)size.x + (Math.floor(heightIncrease * size.x / size.y) + 1.0));
                size.y += heightIncrease;
                Activator.getLogger().debug("Increasing size to: x = " + size.x + " y = " + size.y);
            }
            LayoutHelper layoutHelper = new LayoutHelper(model, size.x, size.y);
            layoutHelper.doLayout();
            heightIncrease = LayoutHelper.calculateHeightIncrease((AbstractNode)model);
            if (heightIncrease <= 0) break;
            ++i;
        }
        Rectangle r = model.getLayout();
        if (r != null) {
            r = r.getCopy();
            if (size.x > r.width) {
                r.width = size.x;
            }
            if (size.y > r.height) {
                r.height = size.y;
            }
            model.setLayout(r);
        }
    }

    private static int calculateHeightIncrease(AbstractNode model) {
        int answer = 0;
        int nextY = 0;
        boolean first = true;
        for (AbstractNode node : model.getChildren()) {
            Rectangle r = node.getLayout();
            if (r == null) continue;
            if (first) {
                first = false;
            } else {
                int delta = nextY - r.y;
                if (delta > 0) {
                    answer += delta;
                }
            }
            nextY = r.y + r.height + 100;
        }
        return answer;
    }

    public LayoutHelper(RouteContainer model, int width, int height) {
        this.defaultNodeWidth = AbstractNode.DEFAULT_LAYOUT.width;
        this.defaultNodeHeight = AbstractNode.DEFAULT_LAYOUT.height;
        this.defaultRouteDepth = this.defaultNodeHeight * 5;
        this.defaultNodeOffset = 10;
        this.defaultRouteOffset = 4;
        this.defaultRouteWidthMargin = 14;
        this.defaultRouteHeightMargin = 14;
        this.x = 0.0;
        this.y = 0.0;
        this.map = new HashMap<AbstractNode, LayoutEntity>();
        this.horizontal = true;
        this.model = model;
        this.width = width;
        this.height = height;
        if (width < 10) {
            this.width = 400;
        }
        if (height < 10) {
            this.height = 350;
        }
        this.nodes = model.getDescendents();
        HashSet flows = new HashSet();
        this.entities = new LayoutEntity[this.nodes.size()];
        int idx = 0;
        for (AbstractNode node : this.nodes) {
            LayoutEntity entity = this.createLayoutEntity(node);
            this.map.put(node, entity);
            this.entities[idx++] = entity;
            flows.addAll(node.getAllConnections());
        }
        this.relations = new LayoutRelationship[flows.size()];
        idx = 0;
        for (Flow flow : flows) {
            this.relations[idx++] = this.createLayoutRelation(flow);
        }
    }

    public void doLayout() {
        try {
            this.ensureNodesAreNotOnTopOfEachOther(this.nodes);
            this.getLayout().applyLayout(this.entities, this.relations, this.x, this.y, (double)this.width, (double)this.height, this.asynchronous, this.continuous);
            this.moveNodesToTop();
        }
        catch (InvalidLayoutConfiguration e) {
            Activator.getLogger().error("Failed to layout graph: " + (Object)((Object)e), (Throwable)e);
        }
    }

    protected void moveNodesToTop() {
        for (AbstractNode node : this.model.getChildren()) {
            this.setRouteSize(node);
        }
    }

    protected void setRouteSize(AbstractNode route) {
        int x_min = 0;
        int y_min = 0;
        int maxWidth = 300;
        int maxHeight = 50;
        boolean first = true;
        for (AbstractNode node : route.getChildren()) {
            node.layout();
            Rectangle r = node.getLayout();
            if (first) {
                first = false;
                x_min = r.x;
                y_min = r.y;
                maxWidth = r.x + r.width;
                maxHeight = r.y + r.height;
                continue;
            }
            x_min = Math.min(x_min, r.x);
            y_min = Math.min(y_min, r.y);
            maxWidth = Math.max(maxWidth, r.x + r.width);
            maxHeight = Math.max(maxHeight, r.y + r.height);
        }
        x_min = Math.max(0, x_min - 5);
        y_min = Math.max(0, y_min - 5);
        maxWidth += 250;
        maxHeight += 150;
        route.setLayout(new Rectangle(x_min, y_min, maxWidth -= x_min, maxHeight -= y_min));
    }

    protected void showRouteLayout() {
        List children = this.model.getChildren();
        if (children.size() > 0) {
            AbstractNode child = (AbstractNode)children.get(0);
            Activator.getLogger().debug("First child layout: " + child.getLayout() + " child: " + child);
        }
    }

    private void ensureNodesAreNotOnTopOfEachOther(Set<AbstractNode> nodes) {
        int nodeCount = 0;
        for (AbstractNode node : nodes) {
            Rectangle r = node.getLayout();
            r = r == null ? new Rectangle() : new Rectangle(r);
            if (node instanceof RouteSupport) {
                if (r.x == 0 && r.y == 0) {
                    r.width = this.width - this.defaultRouteWidthMargin;
                }
                nodeCount = 0;
            } else if (!(node instanceof RouteContainer)) {
                if (r.x == 0 && r.y == 0) {
                    r.x = nodeCount * this.defaultNodeWidth;
                }
                ++nodeCount;
            }
            node.setLayout(r);
        }
    }

    public LayoutAlgorithm getLayout() {
        if (this.layout == null) {
            int style = 0;
            this.layout = this.horizontal ? new HorizontalTreeLayoutAlgorithm(style) : new TreeLayoutAlgorithm(style);
        }
        return this.layout;
    }

    public void setLayout(LayoutAlgorithm layout) {
        this.layout = layout;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean continuous) {
        this.continuous = continuous;
    }

    public RouteContainer getModel() {
        return this.model;
    }

    protected LayoutEntity getLayoutEntity(AbstractNode node) {
        if (node != null) {
            return this.map.get(node);
        }
        return null;
    }

    protected LayoutRelationship createLayoutRelation(final Flow flow) {
        return new LayoutRelationship(){

            public void setGraphData(Object o) {
            }

            public Object getGraphData() {
                return null;
            }

            public LayoutEntity getSourceInLayout() {
                return LayoutHelper.this.getLayoutEntity(flow.getSource());
            }

            public LayoutEntity getDestinationInLayout() {
                return LayoutHelper.this.getLayoutEntity(flow.getTarget());
            }

            public void setLayoutInformation(Object layoutInformation) {
            }

            public Object getLayoutInformation() {
                return null;
            }

            public void setBendPoints(LayoutBendPoint[] bendPoints) {
            }

            public void clearBendPoints() {
            }

            public void populateLayoutConstraint(LayoutConstraint constraint) {
            }
        };
    }

    protected LayoutEntity createLayoutEntity(AbstractNode node) {
        return new NodeLayoutEntity(node);
    }

    public static class NodeLayoutEntity
    implements LayoutEntity {
        private final AbstractNode node;
        private Object graphData;
        private Object layoutInformation;

        public NodeLayoutEntity(AbstractNode node) {
            this.node = node;
        }

        public int compareTo(Object that) {
            if (this == that) {
                return 0;
            }
            return 0;
        }

        public void setGraphData(Object graphData) {
            this.graphData = graphData;
        }

        public Object getGraphData() {
            return this.graphData;
        }

        public void setLocationInLayout(double x, double y) {
            Rectangle r = this.node.getLayout();
            r.x = (int)Math.round(x);
            r.y = (int)Math.round(y);
            Rectangle c = this.node.getLayout();
            if (c != null) {
                r.width = c.width;
                r.height = c.height;
            }
            this.node.setLayout(r);
        }

        public void setSizeInLayout(double width, double height) {
            if (this.isAllowResize()) {
                Rectangle r = this.node.getLayout();
                r.width = (int)Math.round(width);
                r.height = (int)Math.round(height);
                Rectangle c = this.node.getLayout();
                if (c != null) {
                    r.x = c.x;
                    r.y = c.y;
                }
                this.node.setLayout(r);
            }
        }

        public double getXInLayout() {
            Rectangle r = this.node.getLayout();
            if (r != null) {
                return r.x;
            }
            return 0.0;
        }

        public double getYInLayout() {
            Rectangle r = this.node.getLayout();
            if (r != null) {
                return r.y;
            }
            return 0.0;
        }

        public double getWidthInLayout() {
            Rectangle r = this.node.getLayout();
            if (r != null) {
                return r.width;
            }
            return 0.0;
        }

        public double getHeightInLayout() {
            Rectangle r = this.node.getLayout();
            if (r != null) {
                return r.height;
            }
            return 0.0;
        }

        public Object getLayoutInformation() {
            return this.layoutInformation;
        }

        public void setLayoutInformation(Object layoutInformation) {
            this.layoutInformation = layoutInformation;
        }

        public void populateLayoutConstraint(LayoutConstraint constraint) {
        }

        public boolean isAllowResize() {
            return false;
        }
    }
}

