/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.editor;

import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.editor.AbstractNodes;
import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.EditorMessages;
import com.fusesource.rider.editor.commands.DiagramOperations;
import com.fusesource.rider.editor.commands.ImportCamelContextElementsCommand;
import com.fusesource.rider.editor.editor.CamelDiagramEditorContextMenuProvider;
import com.fusesource.rider.editor.editor.INodeViewer;
import com.fusesource.rider.editor.editor.ModelChangeListener;
import com.fusesource.rider.editor.editor.PropertyChangeCommand;
import com.fusesource.rider.editor.editor.RiderDesignEditorData;
import com.fusesource.rider.editor.editor.RiderEditor;
import com.fusesource.rider.editor.editor.RiderEditorContextMenuProvider;
import com.fusesource.rider.editor.editor.io.CamelContextIOUtils;
import com.fusesource.rider.editor.outline.RiderOutlinePage;
import com.fusesource.rider.editor.utils.CamelContextSelectionSynchronizer;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import com.fusesource.rider.model.generated.Route;
import com.fusesource.rider.model.io.ICamelEditorInput;
import com.fusesource.rider.model.io.IRemoteCamelEditorInput;
import com.fusesource.rider.preferences.PreferenceManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.fusesource.camel.rider.util.ValidationHandler;
import org.fusesource.scalate.util.IOUtil;

public class RiderDesignEditor
extends DiagramEditor
implements INodeViewer {
    boolean recreateModel = true;
    private final RiderDesignEditorData data;
    private RiderEditor editor;
    private KeyHandler keyHandler;
    private AbstractEditPart selectedEditPart;
    private AbstractEditPart lastSelectedEditPart;
    private boolean asyncSwitchToSource;
    private boolean disableCommandEvents;
    private IEditorSite editorSite;
    private IEditorInput editorInput;
    private IFeatureProvider featureProvider;
    private Diagram diagram;
    private DiagramEditorInput diagramInput;
    private IProject container;
    private IFile camelContextFile;
    private RouteContainer model;
    private RouteSupport activeRoute;
    private CamelContextSelectionSynchronizer synchronizer;
    private static final boolean selectFirstRouteOnLayout = true;
    private boolean graphitiDoesNotMarkAsDirty = true;
    private DesignerCache activeConfig;
    private Map<RouteSupport, DesignerCache> cache = new HashMap<RouteSupport, DesignerCache>();
    private PropertyChangeListener nodePropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CommandStack commandStack = RiderDesignEditor.this.getCommandStack();
            if (commandStack != null) {
                PropertyChangeCommand command = new PropertyChangeCommand(evt);
                commandStack.execute((org.eclipse.gef.commands.Command)command);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramOperations.updateSelectedNode(RiderDesignEditor.this);
                }
            });
            if (RiderDesignEditor.this.selectedEditPart != null) {
                RiderDesignEditor.this.selectedEditPart.refresh();
            } else if (RiderDesignEditor.this.lastSelectedEditPart != null) {
                RiderDesignEditor.this.lastSelectedEditPart.refresh();
            }
        }
    };
    private Composite parent;
    private TransactionalEditingDomain editingDomain;

    public static RiderDesignEditor toRiderDesignEditor(IDiagramEditor editor) {
        if (editor instanceof RiderDesignEditor) {
            return (RiderDesignEditor)editor;
        }
        return null;
    }

    public static RiderDesignEditor toRiderDesignEditor(IFeatureProvider fp) {
        if (fp == null) {
            return null;
        }
        return RiderDesignEditor.toRiderDesignEditor(fp.getDiagramTypeProvider());
    }

    public static RiderDesignEditor toRiderDesignEditor(IDiagramTypeProvider diagramTypeProvider) {
        if (diagramTypeProvider == null) {
            return null;
        }
        return RiderDesignEditor.toRiderDesignEditor(diagramTypeProvider.getDiagramEditor());
    }

    public RiderDesignEditor(RiderEditor parent) {
        this.data = parent.getDesignEditorData();
        this.activeConfig = new DesignerCache();
        this.editor = parent;
    }

    public void init(IEditorSite editorSite, IEditorInput input) throws PartInitException {
        this.editorSite = editorSite;
        this.editorInput = input;
        this.diagramInput = null;
        this.diagramInput = input instanceof DiagramEditorInput ? (DiagramEditorInput)input : this.createDiagramInput(this.editorInput);
        if (this.recreateModel) {
            this.updateDiagramInput();
        } else {
            this.activeConfig.input = this.diagramInput;
            super.init(editorSite, (IEditorInput)this.diagramInput);
            this.autoLayoutRoute();
            this.fireModelChanged();
        }
    }

    protected void setInput(IEditorInput input) {
        this.setPartName(input.getName());
        if (this.recreateModel) {
            super.setInput(input);
            if (this.data.loadModelOnSetInput) {
                this.loadModelFromInput(input);
            }
        } else {
            this.activeConfig.input = input instanceof DiagramEditorInput ? (DiagramEditorInput)input : this.createDiagramInput(input);
            super.setInput((IEditorInput)this.activeConfig.input);
            this.autoLayoutRoute();
            this.fireModelChanged();
        }
        this.setupGridVisibility();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
    }

    protected void contributeToActionBars() {
        IActionBars bars = null;
        if (this.editorSite == null) {
            Activator.getLogger().warning("No IEditorSite registered for " + this);
            return;
        }
        bars = this.editorSite.getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }

    public Composite getParent() {
        return this.parent;
    }

    protected DiagramEditorInput createDiagramInput(IEditorInput input) {
        IFileEditorInput fileEditorInput = this.asFileEditorInput(input);
        if (fileEditorInput != null) {
            this.camelContextFile = fileEditorInput.getFile();
            this.container = this.camelContextFile.getProject();
            if (this.getModel() == null) {
                this.model = CamelContextIOUtils.loadModelFromFile(this.camelContextFile);
                ValidationHandler status = CamelContextIOUtils.validateModel(this.model);
                if (status.hasErrors()) {
                    Activator.getLogger().error("Unable to validate the model. Invalid input!");
                    return null;
                }
            }
            return this.createDiagram();
        }
        IRemoteCamelEditorInput remoteEditorInput = this.asRemoteCamelEditorInput(input);
        if (remoteEditorInput != null) {
            this.camelContextFile = null;
            this.container = null;
            if (this.getModel() == null) {
                try {
                    String text = remoteEditorInput.getXml();
                    this.model = CamelContextIOUtils.loadModelFromText(text);
                    ValidationHandler status = CamelContextIOUtils.validateModel(this.model);
                    if (status.hasErrors()) {
                        Activator.getLogger().error("Unable to validate the model. Invalid input!");
                        return null;
                    }
                }
                catch (IOException e) {
                    Activator.getLogger().error("Unable to load the model: " + e, (Throwable)e);
                    return null;
                }
            }
            return this.createDiagram();
        }
        if (input instanceof DiagramEditorInput) {
            if (this.recreateModel) {
                if (this.diagram == null) {
                    this.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
                    DiagramOperations.execute(this.editingDomain, new ImportCamelContextElementsCommand(this, this.editingDomain, this.diagram), true);
                    this.diagramInput = DiagramEditorInput.createEditorInput((Diagram)this.diagram, (TransactionalEditingDomain)this.editingDomain, (String)GraphitiInternal.getEmfService().getDTPForDiagram(this.diagram).getProviderId(), (boolean)false);
                }
                return this.diagramInput;
            }
            if (this.activeConfig.diagram == null) {
                this.activeConfig.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
                DiagramOperations.execute(this.editingDomain, new ImportCamelContextElementsCommand(this, this.editingDomain, this.activeConfig.diagram), true);
                this.activeConfig.input = DiagramEditorInput.createEditorInput((Diagram)this.activeConfig.diagram, (TransactionalEditingDomain)this.editingDomain, (String)GraphitiInternal.getEmfService().getDTPForDiagram(this.activeConfig.diagram).getProviderId(), (boolean)false);
            }
            return this.activeConfig.input;
        }
        return null;
    }

    protected DiagramEditorInput createDiagram() {
        if (this.recreateModel) {
            this.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
        } else {
            this.activeConfig.diagram = Graphiti.getPeCreateService().createDiagram("CamelContext", "CamelContext", true);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
        if (this.editingDomain == null) {
            this.editingDomain = DiagramEditorFactory.createResourceSetAndEditingDomain();
            resourceSet = this.editingDomain.getResourceSet();
        }
        if (this.recreateModel) {
            this.editingDomain.getCommandStack().execute((Command)new ImportCamelContextElementsCommand(this, this.editingDomain, this.diagram));
            return DiagramEditorInput.createEditorInput((Diagram)this.diagram, (TransactionalEditingDomain)this.editingDomain, (String)GraphitiInternal.getEmfService().getDTPForDiagram(this.diagram).getProviderId(), (boolean)false);
        }
        this.editingDomain.getCommandStack().execute((Command)new ImportCamelContextElementsCommand(this, this.editingDomain, this.activeConfig.diagram));
        return DiagramEditorInput.createEditorInput((Diagram)this.activeConfig.diagram, (TransactionalEditingDomain)this.editingDomain, (String)GraphitiInternal.getEmfService().getDTPForDiagram(this.activeConfig.diagram).getProviderId(), (boolean)false);
    }

    public void setEditingDomain(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public String getCamelContextURI() {
        IFile file;
        RouteSupport selectedRoute = this.getSelectedRoute();
        String id = selectedRoute.getId();
        if (id == null || id.length() == 0) {
            id = "#" + selectedRoute.hashCode();
        }
        if ((file = this.getCamelContextFile()) != null) {
            return String.valueOf(file.getFullPath().toString()) + "_" + id;
        }
        IRemoteCamelEditorInput input = this.getRemoteCamelEditorInput();
        if (input != null) {
            return input.getUriText();
        }
        return id;
    }

    private IFile getCamelContextFile() {
        if (this.recreateModel) {
            IFileEditorInput fileEditorInput = this.getFileEditorInput();
            if (fileEditorInput != null) {
                return fileEditorInput.getFile();
            }
            return null;
        }
        return this.camelContextFile;
    }

    protected IFileEditorInput getFileEditorInput() {
        return this.asFileEditorInput(this.editorInput);
    }

    protected IRemoteCamelEditorInput getRemoteCamelEditorInput() {
        return this.asRemoteCamelEditorInput(this.editorInput);
    }

    protected IFileEditorInput asFileEditorInput(IEditorInput input) {
        ICamelEditorInput camelEditorInput;
        IEditorInput fileEditorInput;
        if (input instanceof IFileEditorInput) {
            return (IFileEditorInput)input;
        }
        if (input instanceof ICamelEditorInput && (fileEditorInput = (camelEditorInput = (ICamelEditorInput)input).getFileEditorInput()) instanceof IFileEditorInput) {
            return (IFileEditorInput)fileEditorInput;
        }
        return null;
    }

    protected IRemoteCamelEditorInput asRemoteCamelEditorInput(IEditorInput input) {
        if (input instanceof IRemoteCamelEditorInput) {
            return (IRemoteCamelEditorInput)input;
        }
        if (input instanceof ICamelEditorInput) {
            ICamelEditorInput camelEditorInput = (ICamelEditorInput)input;
            IEditorInput fileEditorInput = camelEditorInput.getFileEditorInput();
            if (fileEditorInput instanceof IRemoteCamelEditorInput) {
                return (IRemoteCamelEditorInput)fileEditorInput;
            }
        } else if (input instanceof IURIEditorInput) {
            final IURIEditorInput uriInput = (IURIEditorInput)input;
            return new IRemoteCamelEditorInput(){

                public String getUriText() {
                    return uriInput.getName();
                }

                public String getXml() throws IOException {
                    return IOUtil.loadText((InputStream)uriInput.getURI().toURL().openStream(), (String)"UTF-8");
                }
            };
        }
        return null;
    }

    @Override
    public AbstractNode getSelectedNode() {
        return AbstractNodes.getSelectedNode(Selections.getSelection((IWorkbenchSite)this.getEditorSite()));
    }

    @Override
    public void setSelectedNode(AbstractNode newSelection) {
        if (newSelection != null) {
            EditPart selectEditPart = RiderDesignEditor.findEditPart(newSelection, (EditPart)this.getRootEditPart());
            if (selectEditPart != null) {
                this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)selectEditPart));
            } else {
                Activator.getLogger().error("Could not find editPart for selection: " + newSelection, (Throwable)new Exception());
            }
        }
        this.data.selectedNode = newSelection;
    }

    public static EditPart findEditPart(AbstractNode node, EditPart part) {
        EditPart nodeEditPart;
        AbstractNode modelNode;
        RootEditPart root;
        EditPart contents;
        if (part instanceof RootEditPart && (contents = (root = (RootEditPart)part).getContents()) != null) {
            return RiderDesignEditor.findEditPart(node, contents);
        }
        if (part instanceof EditPart && Objects.equal((Object)node, (Object)(modelNode = AbstractNodes.toAbstractNode(nodeEditPart = part)))) {
            return nodeEditPart;
        }
        List children = part.getChildren();
        for (EditPart childPart : children) {
            EditPart answer = RiderDesignEditor.findEditPart(node, childPart);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    public AbstractEditPart getLastSelectedEditPart() {
        return this.lastSelectedEditPart;
    }

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.getSite().getPage().getActiveEditor() == this.editor && this.editor.getActiveEditor() == this) {
            StructuredSelection structuredSelection;
            Object firstElement;
            this.updateActions(this.getSelectionActions());
            if (selection instanceof StructuredSelection && (firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof AbstractEditPart) {
                this.selectedEditPart = (AbstractEditPart)firstElement;
                AbstractNode node = AbstractNodes.toAbstractNode(firstElement);
                if (node != null) {
                    if (this.data.selectedNode != null) {
                        this.data.selectedNode.removePropertyChangeListener(this.nodePropertyListener);
                    }
                    this.data.selectedNode = node;
                    this.data.selectedNode.addPropertyChangeListener(this.nodePropertyListener);
                }
                if (this.selectedEditPart != null) {
                    this.lastSelectedEditPart = this.selectedEditPart;
                }
            }
        }
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        RiderEditorContextMenuProvider provider = new RiderEditorContextMenuProvider(this, this, (EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.fireModelDirty();
    }

    protected void fireModelDirty() {
        this.firePropertyChange(257);
        boolean changed = this.getCommandStack().isDirty();
        if (!this.disableCommandEvents && (changed || this.graphitiDoesNotMarkAsDirty)) {
            this.data.diagramChanged = true;
        }
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new CamelDiagramEditorContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry(), this.getConfigurationProvider());
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(final Object template) {
                if (template instanceof CreationFactory) {
                    return (CreationFactory)template;
                }
                if (template instanceof Class) {
                    return new SimpleFactory((Class)template);
                }
                System.out.println("============= Template: " + template + " is not a CreationFactory or Class! " + Objects.typeName((Object)template));
                return new CreationFactory(){

                    public Object getNewObject() {
                        return template;
                    }

                    public Object getObjectType() {
                        if (template == null) {
                            return null;
                        }
                        return template.getClass();
                    }
                };
            }
        };
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class || type == GraphicalEditorWithFlyoutPalette.class || type == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == EditDomain.class) {
            return this.getEditDomain();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == ZoomManager.class) {
            RootEditPart root = this.getGraphicalViewer().getRootEditPart();
            if (root instanceof ScalableRootEditPartAnimated) {
                ScalableRootEditPartAnimated scalableRoot = (ScalableRootEditPartAnimated)root;
                return scalableRoot.getZoomManager();
            }
            if (root instanceof ScalableRootEditPart) {
                return ((ScalableRootEditPart)root).getZoomManager();
            }
            return null;
        }
        if (type == IContentOutlinePage.class) {
            return new RiderOutlinePage(this);
        }
        return super.getAdapter(type);
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    private void handleLoadException(Exception e) {
        Activator.getLogger().error("** Load failed. Using default model. **", (Throwable)e);
        try {
            this.setModel(new RouteContainer());
        }
        catch (PartInitException partInitException) {
            Activator.getLogger().warning("Failed to reload the diagram: " + e, (Throwable)e);
        }
        this.getModel().setFailedToParseXml(true);
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveModelToFile();
        StructuredTextEditor sourceEditor = this.editor.getSourceEditor();
        if (sourceEditor != null) {
            ProgressMonitorWrapper wrapper = this.createSaveProgressMonitorWrapper(monitor);
            sourceEditor.doSave((IProgressMonitor)wrapper);
        } else {
            this.getCommandStack().markSaveLocation();
        }
    }

    public void doSaveAs() {
        this.saveModelToFile();
        StructuredTextEditor sourceEditor = this.editor.getSourceEditor();
        if (sourceEditor != null) {
            sourceEditor.doSaveAs();
        }
    }

    public ProgressMonitorWrapper createSaveProgressMonitorWrapper(IProgressMonitor monitor) {
        ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){

            public void done() {
                super.done();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RiderDesignEditor.this.saveCamelEditorInput();
                        RiderDesignEditor.this.markXmlSaved();
                    }
                });
            }
        };
        return wrapper;
    }

    public boolean isSaveAsAllowed() {
        return this.editor.isSaveAsAllowed();
    }

    public void update() {
        DiagramOperations.updateDiagram(this);
        this.refresh();
        if (this.getDiagram() != null) {
            this.selectPictogramElements(new PictogramElement[]{this.getDiagram().getContainer()});
        }
    }

    public void fireModelChanged() {
        for (ModelChangeListener listener : this.data.modelChangeListeners) {
            listener.onModelChange();
        }
    }

    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public RouteContainer getModel() {
        if (this.recreateModel) {
            if (this.data.model == null && this.editorInput != null) {
                this.data.lazyLoading = true;
                try {
                    this.loadModelFromInput(this.editorInput);
                }
                finally {
                    this.data.lazyLoading = false;
                }
            }
            return this.data.model;
        }
        return this.model;
    }

    public void setModel(RouteContainer model) throws PartInitException {
        if (this.recreateModel) {
            if (model != this.data.model) {
                this.data.model = model;
                this.data.selectedRoute = null;
                this.updateDiagramIfNotLazyLoading();
            }
        } else {
            DiagramEditorInput inputOld = this.activeConfig.input;
            this.clearCache();
            this.activeConfig.input = inputOld;
            this.cache.clear();
            this.model = model;
            this.switchRoute((RouteSupport)this.model.getChildren().get(0));
        }
    }

    public RouteSupport getSelectedRoute() {
        if (this.recreateModel) {
            List children;
            if (this.data.selectedRoute == null && (children = this.getModel().getChildren()) != null) {
                AbstractNode node;
                int size = children.size();
                int idx = this.data.selectedRouteIndex;
                if (idx < 0 || idx >= size) {
                    idx = 0;
                }
                if (size > 0 && (node = (AbstractNode)children.get(idx)) instanceof RouteSupport) {
                    this.data.selectedRoute = (RouteSupport)node;
                }
            }
            if (this.data.selectedRoute == null) {
                this.setInitialRoute();
            }
            return this.data.selectedRoute;
        }
        if (this.activeRoute == null) {
            this.setInitialRoute();
        }
        return this.activeRoute;
    }

    public void clearSelectedRouteCache() {
        this.data.selectedRoute = null;
        this.data.selectedRouteIndex = -1;
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        if (this.recreateModel) {
            if (this.data.selectedRoute != selectedRoute) {
                int index = this.data.indexOfRoute(selectedRoute);
                this.setSelectedRouteIndex(index);
            }
        } else {
            this.switchRoute(selectedRoute);
        }
    }

    public void switchRoute(RouteSupport newRoute) {
        if (newRoute == this.activeRoute) {
            return;
        }
        if (this.activeRoute != null) {
            this.cache.put(this.activeRoute, this.activeConfig);
        }
        this.activeRoute = newRoute;
        if (this.cache.containsKey(newRoute)) {
            this.activeConfig = this.cache.get(newRoute);
        } else {
            DiagramEditorInput oldInput = this.activeConfig.input;
            this.activeConfig = new DesignerCache();
            this.activeConfig.input = oldInput;
        }
        this.setInput((IEditorInput)this.createDiagramInput((IEditorInput)this.activeConfig.input));
        this.refresh();
    }

    private void setInitialRoute() {
        if (this.getModel() != null) {
            if (this.getModel().getChildren().isEmpty()) {
                Route route = new Route();
                this.getModel().addChild((AbstractNode)route);
            }
            this.activeRoute = (RouteSupport)this.getModel().getChildren().get(0);
            if (this.recreateModel) {
                this.data.selectedRoute = this.activeRoute;
            }
        }
    }

    public void setSelectedRouteIndex(int index) {
        if (this.data.selectedRouteIndex != index) {
            DesignerCache value;
            if (!this.recreateModel) {
                RouteSupport oldRoute = this.getSelectedRoute();
                if (this.diagram != null && oldRoute != null) {
                    value = new DesignerCache();
                    value.diagram = this.diagram;
                    value.input = this.diagramInput;
                    this.cache.put(oldRoute, value);
                }
            }
            this.data.selectedRouteIndex = index;
            this.data.selectedRoute = null;
            if (this.recreateModel) {
                this.data.recreateModel();
                this.setupGridVisibility();
                try {
                    this.updateDiagramIfNotLazyLoading();
                }
                catch (PartInitException e) {
                    Activator.getLogger().warning("Failed to update diagram on route selection change: " + (Object)((Object)e), (Throwable)e);
                }
            } else {
                RouteSupport route = this.getSelectedRoute();
                value = this.cache.get(route);
                if (value == null || value.input == null) {
                    this.diagram = null;
                    this.diagramInput = this.createDiagramInput((IEditorInput)this.diagramInput);
                } else {
                    this.diagram = value.diagram;
                    this.diagramInput = value.input;
                }
                this.setInput((IEditorInput)this.diagramInput);
                this.refresh();
            }
        }
    }

    public void setupGridVisibility() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiagramOperations.updateGridColor(RiderDesignEditor.this);
                boolean gridVisible = PreferenceManager.getInstance().loadPreferenceAsBoolean("diagramGridVisibilityPreference");
                DiagramUtils.setGridVisible(gridVisible);
            }
        });
    }

    public IProject getContainer() {
        return this.container;
    }

    private void updateDiagramIfNotLazyLoading() throws PartInitException {
        if (!this.data.lazyLoading) {
            this.clearCache();
            this.editor.recreateDesignPage();
            this.fireModelChanged();
        }
    }

    private void updateDiagramInput() throws PartInitException {
        super.init(this.editorSite, (IEditorInput)this.diagramInput);
        boolean syncLayout = true;
        if (syncLayout) {
            this.autoLayoutRoute();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RiderDesignEditor.this.autoLayoutRoute();
                }
            });
        }
    }

    public SelectionSynchronizer getSelectionSynchronizerInternal() {
        if (this.recreateModel) {
            return super.getSelectionSynchronizerInternal();
        }
        return this.getSelectionSynchronizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.recreateModel) {
            return super.getSelectionSynchronizer();
        }
        RiderDesignEditor riderDesignEditor = this;
        synchronized (riderDesignEditor) {
            if (this.synchronizer == null) {
                this.synchronizer = new CamelContextSelectionSynchronizer(this);
            }
        }
        return this.synchronizer;
    }

    public KeyHandler getKeyHandler() {
        return this.keyHandler;
    }

    public void dispose() {
        this.editorInput = null;
        this.diagram = null;
        ActionRegistry actionRegistry = this.getActionRegistry();
        if (actionRegistry != null) {
            actionRegistry.dispose();
        }
        super.dispose();
    }

    protected void loadModelFromInput(IEditorInput editorInput) {
        block12: {
            this.data.loaded = false;
            try {
                try {
                    if (editorInput instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)editorInput).getFile();
                        this.loadModelFromFile(file);
                        break block12;
                    }
                    if (editorInput instanceof ICamelEditorInput) {
                        ICamelEditorInput camelInput = (ICamelEditorInput)editorInput;
                        this.editor.onInputLoading((IEditorInput)camelInput);
                        this.setModel(camelInput.loadModel());
                        break block12;
                    }
                    if (editorInput instanceof IURIEditorInput) {
                        this.editor.onInputLoading(editorInput);
                        IURIEditorInput uriInput = (IURIEditorInput)editorInput;
                        URI uri = uriInput.getURI();
                        URL url = uri.toURL();
                        if (url == null) {
                            Activator.getLogger().warning("Unsupported URI type " + uri);
                        } else {
                            String xml = IOUtil.loadText((InputStream)url.openStream(), (String)"UTF-8");
                            this.setModel(this.data.marshaller.loadRoutesFromText(xml));
                        }
                        break block12;
                    }
                    this.editor.onInputLoading(editorInput);
                    Activator.getLogger().warning("Unsupported IEditorInput type " + editorInput);
                }
                catch (Exception e) {
                    this.handleLoadException(e);
                    this.switchToSourceEditor();
                    if (!this.asyncSwitchToSource) {
                        this.data.loaded = true;
                    }
                }
            }
            finally {
                if (!this.asyncSwitchToSource) {
                    this.data.loaded = true;
                }
            }
        }
    }

    protected void switchToSourceEditor() {
        this.asyncSwitchToSource = true;
        this.editor.switchToSourceEditor();
    }

    public void loadModelFromFile(IFile file) throws IOException, PartInitException {
        this.editor.onFileLoading(file);
        this.setModel(this.data.marshaller.loadRoutes(file));
        ValidationHandler status = this.getModel().validate();
        if (status.hasErrors()) {
            this.switchToSourceEditor();
        }
    }

    public void loadModelFromRemoteContext(ICamelEditorInput editorInput) throws IOException, PartInitException {
        this.editor.onInputLoading((IEditorInput)editorInput);
        this.setModel(editorInput.loadModel());
    }

    public void loadEditorText(String text) {
        try {
            this.setModel(this.data.marshaller.loadRoutesFromText(text));
            this.validateXml();
        }
        catch (Exception e) {
            this.showValidationError(e);
        }
    }

    public void validateXml() {
        if (this.data.loaded) {
            if (this.getModel() == null || this.getModel().isFailedToParseXml()) {
                IDocument document = this.editor.getDocument();
                if (document != null) {
                    String text = document.get();
                    this.loadEditorText(text);
                }
            } else {
                ValidationHandler status = this.getModel().validate();
                if (status.hasErrors()) {
                    String error = status.userMessage();
                    this.showXmlValidationError(error);
                }
            }
        }
    }

    public void autoLayoutRoute() {
        DiagramOperations.layoutDiagram(this);
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setTransactionalEditingDomain(TransactionalEditingDomain editingDomain) {
    }

    protected DiagramEditorInput getDiagramInput() {
        DiagramEditorInput diagramInput = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof DiagramEditorInput) {
            diagramInput = (DiagramEditorInput)input;
        }
        return diagramInput;
    }

    public void saveModelToFile() {
        try {
            this.disableCommandEvents = true;
            this.editor.updatedDesignPage(false);
        }
        finally {
            this.disableCommandEvents = false;
        }
        this.saveCamelEditorInput();
    }

    protected void saveCamelEditorInput() {
        if (this.editorInput instanceof ICamelEditorInput) {
            ICamelEditorInput camelInput = (ICamelEditorInput)this.editorInput;
            IDocument document = this.editor.getDocument();
            if (document != null) {
                String xml = document.get();
                camelInput.save(xml);
            }
        }
    }

    public String updateEditorText(String editorXml) {
        return this.data.marshaller.updateText(editorXml, this.getModel());
    }

    public void runIfDiagramModified(Runnable block) {
        this.runIfDiagramModified(block, true);
    }

    public void runIfDiagramModified(Runnable block, boolean async) {
        this.data.shownValidationError = false;
        if (this.data.diagramChanged) {
            try {
                if (async) {
                    Display.getDefault().syncExec(block);
                } else {
                    block.run();
                }
            }
            finally {
                this.clearChangedFlags();
            }
        }
    }

    protected void clearChangedFlags() {
        this.data.diagramChanged = false;
        this.data.textChanged = false;
        this.getCommandStack().markSaveLocation();
        this.getEditingDomain().getCommandStack().flush();
    }

    public void onTextEditorPropertyChange() {
        this.data.textChanged = true;
    }

    public void runIfTextModified(Runnable block) {
        block8: {
            if (this.data.textChanged) {
                try {
                    try {
                        Display.getDefault().syncExec(block);
                        this.validateXml();
                    }
                    catch (Exception e) {
                        this.showValidationError(e);
                        this.clearChangedFlags();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.clearChangedFlags();
                    throw throwable;
                }
                this.clearChangedFlags();
            } else {
                this.validateXml();
            }
        }
        if (this.asyncSwitchToSource) {
            this.asyncSwitchToSource = false;
            this.data.loaded = true;
        }
    }

    protected void showValidationError(Exception e) {
        String text = e.getMessage();
        if (e instanceof RuntimeException) {
            Throwable cause = e.getCause();
            if (cause != null) {
                text = cause.getMessage();
                cause.printStackTrace();
            } else {
                e.printStackTrace();
            }
        }
        this.showXmlValidationError(text);
    }

    public void showXmlValidationError(String text) {
        if (this.data.loaded && !this.data.shownValidationError) {
            String message = NLS.bind((String)EditorMessages.saveModifiedTextFailedText, (Object)text);
            this.data.shownValidationError = true;
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)EditorMessages.saveModifiedTextFailedTitle, (String)message);
        }
    }

    public void markXmlSaved() {
        CommandStack stack = this.getCommandStack();
        if (stack == null) {
            Activator.getLogger().warning("No command stack available when trying to save document!");
            System.out.println("================= No command stack available when trying to save document!");
        } else {
            stack.markSaveLocation();
        }
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(IFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    protected RootEditPart getRootEditPart() {
        return this.getGraphicalViewer().getRootEditPart();
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.data.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.data.modelChangeListeners.remove(listener);
    }

    public void clearCache() {
        if (!this.recreateModel) {
            try {
                if (this.activeConfig.diagram != null) {
                    this.activeConfig.diagram.eResource().delete(null);
                }
                if (this.getModel() != null && this.getModel().eResource() != null) {
                    this.getModel().eResource().delete(null);
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error("Unable to clear the diagram editor cache.", (Throwable)ex);
            }
            this.cache.clear();
            this.model = null;
            this.activeRoute = null;
            this.activeConfig.input.dispose();
            this.activeConfig = new DesignerCache();
            this.refresh();
        }
    }

    public void addNewRoute() {
        DiagramOperations.addNewRoute(this);
    }

    public void deleteRoute() {
        RouteSupport selectedRoute = this.getSelectedRoute();
        if (selectedRoute != null) {
            DiagramOperations.deleteRoute(this, selectedRoute);
        }
    }

    public RiderEditor getEditor() {
        return this.editor;
    }

    public class DesignerCache {
        public Diagram diagram;
        public DiagramEditorInput input;
    }
}

