/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.editor;

import com.fusesource.rider.commons.ui.Workbenches;
import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.IPrefersPerspective;
import com.fusesource.rider.editor.Messages;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.editor.RiderDesignEditorData;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import com.fusesource.rider.model.io.ICamelEditorInput;
import com.fusesource.rider.model.util.Objects;
import com.fusesource.rider.preferences.PreferenceManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class RiderEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
ITabbedPropertySheetPageContributor,
IPrefersPerspective,
IPropertyChangeListener {
    public static final String RIDER_PERSPECTIVE_ID = "com.fusesource.rider.branding.perspective";
    public static final int DESIGN_PAGE_INDEX = 0;
    public static final int SOURCE_PAGE_INDEX = 1;
    private StructuredTextEditor sourceEditor;
    private RiderDesignEditor designEditor;
    private ISelection savedSelection;
    private RiderDesignEditorData designEditorData = new RiderDesignEditorData();
    private int designPageIndex;

    public RiderEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                this.closeEditorsWithoutValidInput();
                break;
            }
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage[] pages = RiderEditor.this.getSite().getWorkbenchWindow().getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorInput editorInput = RiderEditor.this.sourceEditor.getEditorInput();
                            if (editorInput instanceof FileEditorInput && ((FileEditorInput)editorInput).getFile().getProject().equals((Object)event.getResource())) {
                                IWorkbenchPage page = pages[i];
                                IEditorPart editorPart = page.findEditor(editorInput);
                                page.closeEditor(editorPart, true);
                            }
                            ++i;
                        }
                    }
                });
            }
        }
    }

    protected void closeEditorsWithoutValidInput() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] eds;
                IEditorReference[] iEditorReferenceArray = eds = RiderEditor.this.getSite().getPage().getEditorReferences();
                int n = eds.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorInput editorInput;
                    IEditorReference er = iEditorReferenceArray[n2];
                    IEditorPart editor = er.getEditor(false);
                    if (editor != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput && !((FileEditorInput)editorInput).getFile().exists()) {
                        RiderEditor.this.getSite().getPage().closeEditor(er.getEditor(false), false);
                        if (er != null && er.getEditor(false) != null) {
                            er.getEditor(false).dispose();
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    protected void createPages() {
        this.createDesignPage(0);
        this.createSourcePage(1);
        IDocument document = this.getDocument();
        if (document == null) {
            throw new IllegalStateException("No Document available!");
        }
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                RiderEditor.this.designEditor.onTextEditorPropertyChange();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    private void createSourcePage(int index) {
        try {
            this.sourceEditor = new StructuredTextEditor();
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof ICamelEditorInput) {
                ICamelEditorInput camelEditorInput = (ICamelEditorInput)editorInput;
                editorInput = camelEditorInput.getFileEditorInput();
            }
            this.addPage(index, (IEditorPart)this.sourceEditor, editorInput);
            this.setPageText(index, Messages.editorSourcePageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createDesignPage(int index) {
        try {
            this.designEditor = new RiderDesignEditor(this);
            this.designPageIndex = index;
            IEditorInput editorInput = this.getEditorInput();
            this.addPage(index, (IEditorPart)this.designEditor, editorInput);
            this.setPageText(index, Messages.editorDesignPageTitle);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested design editor", null, (IStatus)e.getStatus());
        }
    }

    public void recreateDesignPage() {
        if (this.designEditor != null) {
            int pageIndex = this.designPageIndex;
            Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
            this.designEditor.getCommandStack().flush();
            CTabFolder tabFolder = (CTabFolder)this.getField(this, "container", MultiPageEditorPart.class);
            ArrayList<RiderDesignEditor> nestedEditors = (ArrayList<RiderDesignEditor>)this.getField(this, "nestedEditors", MultiPageEditorPart.class);
            if (nestedEditors == null) {
                nestedEditors = new ArrayList<RiderDesignEditor>();
            }
            this.designEditor.dispose();
            this.designEditor.getEditDomain().setCommandStack(new CommandStack());
            this.designEditor.getParent().dispose();
            nestedEditors.remove(this.designEditor);
            RiderDesignEditor editor = this.designEditor = new RiderDesignEditor(this);
            nestedEditors.add(editor);
            IEditorInput editorInput = this.getEditorInput();
            IEditorSite site = this.createSite((IEditorPart)editor);
            try {
                CTabItem item;
                editor.init(site, editorInput);
                Composite parent2 = new Composite(this.getContainer(), this.designEditor.getOrientation());
                parent2.setLayout((Layout)new FillLayout());
                editor.createPartControl(parent2);
                editor.addPropertyListener(new IPropertyListener(){

                    public void propertyChanged(Object source, int propertyId) {
                        RiderEditor.this.handlePropertyChange(propertyId);
                    }
                });
                if (tabFolder != null && (item = tabFolder.getItem(this.designPageIndex)) != null) {
                    item.setData((Object)this.designEditor);
                    item.setControl((Control)parent2);
                }
            }
            catch (PartInitException e) {
                Activator.getLogger().warning("Failed to recreate DiagramEditor: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    private Object getField(Object owner, String name, Class<?> aClass) {
        try {
            return Objects.getField((Object)owner, (String)name, aClass);
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to access field: " + name + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    private void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() {
                IWorkbenchPartSite partSite = part.getSite();
                part.dispose();
                if (partSite instanceof MultiPageEditorSite) {
                    ((MultiPageEditorSite)partSite).dispose();
                }
            }

            public void handleException(Throwable e) {
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            if (activeEditor != this.designEditor) {
                monitor = this.designEditor.createSaveProgressMonitorWrapper(monitor);
            }
            activeEditor.doSave(monitor);
        } else {
            this.saveSelection();
            IEditorPart editor1 = this.getEditor(0);
            editor1.doSave(monitor);
            IEditorPart editor2 = this.getEditor(1);
            editor2.doSave(monitor);
            this.restoreSelection();
        }
    }

    public void doSaveAs() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            IEditorInput oldInput = this.getEditorInput();
            if (oldInput instanceof ICamelEditorInput) {
                final ICamelEditorInput camelInput = (ICamelEditorInput)oldInput;
                Shell shell = this.getSite().getShell();
                BasicNewFileResourceWizard wizard = new BasicNewFileResourceWizard(){

                    public void addPages() {
                        super.addPages();
                        IWizardPage page = this.getPage("newFilePage1");
                        if (page instanceof WizardNewFileCreationPage) {
                            final WizardNewFileCreationPage fileCreationPage = (WizardNewFileCreationPage)page;
                            fileCreationPage.setTitle("Save as new file");
                            fileCreationPage.setDescription("Choose the folder and file name to save the routes as a file");
                            IFile lastSaveAsFile = camelInput.getLastSaveAsFile();
                            if (lastSaveAsFile != null) {
                                fileCreationPage.setContainerFullPath(lastSaveAsFile.getFullPath());
                                fileCreationPage.setFileName(lastSaveAsFile.getName());
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Event dummyEvent = new Event();
                                        fileCreationPage.handleEvent(dummyEvent);
                                    }
                                });
                            } else {
                                fileCreationPage.setFileName("routes.xml");
                            }
                        }
                    }

                    protected void selectAndReveal(IResource newResource) {
                        if (newResource instanceof IFile) {
                            IFile file = (IFile)newResource;
                            camelInput.setLastSaveAsFile(file);
                            RiderEditor.this.saveAsFile(file);
                        }
                        super.selectAndReveal(newResource);
                    }
                };
                IWorkbench workbench = Workbenches.getActiveWorkbench();
                StructuredSelection selection = new StructuredSelection();
                wizard.setForcePreviousAndNextButtons(false);
                wizard.setWindowTitle("Save as new file");
                wizard.init(workbench, (IStructuredSelection)selection);
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.setTitle("Save as new file");
                dialog.open();
                return;
            }
            activeEditor.doSaveAs();
        } else {
            this.saveSelection();
            this.doSaveAs(this.getEditor(0));
            this.doSaveAs(this.getEditor(1));
            this.restoreSelection();
        }
    }

    protected void saveAsFile(IFile file) {
        ByteArrayInputStream source = new ByteArrayInputStream(this.getDocument().get().getBytes());
        try {
            if (file.exists()) {
                file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Activator.showUserError("Failed to save file", "Failed to write to " + file, (Exception)((Object)e));
        }
    }

    protected void doSaveAs(IEditorPart editor) {
        editor.doSaveAs();
        this.setPageText(1, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void saveSelection() {
        this.savedSelection = this.getActiveEditor().getEditorSite().getSelectionProvider().getSelection();
    }

    protected void restoreSelection() {
        this.getActiveEditor().getEditorSite().getSelectionProvider().setSelection(this.savedSelection);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        PreferenceManager.getInstance().getUnderlyingStorage().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        this.openPropertiesView();
    }

    private void openPropertiesView() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow wbw;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (page = wbw.getActivePage()) != null) {
                    try {
                        if (page.findView("org.eclipse.ui.views.PropertySheet") == null) {
                            page.showView("org.eclipse.ui.views.PropertySheet");
                        }
                    }
                    catch (PartInitException ex) {
                        Activator.getLogger().error((Throwable)ex);
                    }
                }
            }
        });
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.updatedDesignPage();
        } else {
            this.updatedTextPage();
        }
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    void updatedDesignPage() {
        this.updatedDesignPage(true);
    }

    void updatedDesignPage(boolean async) {
        this.designEditor.runIfDiagramModified(new Runnable(){

            @Override
            public void run() {
                IDocument document = RiderEditor.this.getDocument();
                if (document != null) {
                    String text = document.get();
                    String newText = RiderEditor.this.designEditor.updateEditorText(text);
                    if (!Objects.equal((Object)newText, (Object)text)) {
                        document.set(newText);
                    }
                }
            }
        }, async);
    }

    private void updatedTextPage() {
        this.designEditor.runIfTextModified(new Runnable(){

            @Override
            public void run() {
                IDocument document = RiderEditor.this.getDocument();
                if (document != null) {
                    String text = document.get();
                    Activator.getLogger().debug("Updating the design model from the updated text");
                    RiderEditor.this.designEditor.loadEditorText(text);
                    RiderEditor.this.designEditor.update();
                    RiderEditor.this.designEditor.setFocus();
                }
            }
        });
    }

    public Object getAdapter(Class adapter) {
        Object answer;
        IEditorInput editorInput;
        if (adapter == RiderDesignEditor.class) {
            return this.designEditor;
        }
        if (adapter == TextEditor.class) {
            return this.sourceEditor;
        }
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (adapter == ActionRegistry.class) {
            return this.designEditor.getActionRegistry();
        }
        if (adapter == IDocumentProvider.class && (editorInput = this.getEditorInput()) != null && (answer = editorInput.getAdapter(adapter)) != null) {
            return answer;
        }
        return super.getAdapter(adapter);
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public RiderDesignEditor getDesignEditor() {
        return this.designEditor;
    }

    public AbstractNode getSelectedNode() {
        return this.designEditor.getSelectedNode();
    }

    public void setSelectedNode(AbstractNode newSelection) {
        this.designEditor.setSelectedNode(newSelection);
    }

    public RouteContainer getModel() {
        return this.designEditor.getModel();
    }

    public RouteSupport getSelectedRoute() {
        return this.designEditor.getSelectedRoute();
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        this.designEditor.setSelectedRoute(selectedRoute);
    }

    public RiderDesignEditorData getDesignEditorData() {
        return this.designEditorData;
    }

    public IDocument getDocument() {
        IEditorInput element = this.sourceEditor.getEditorInput();
        IDocumentProvider documentProvider = this.sourceEditor.getDocumentProvider();
        if (documentProvider != null) {
            IDocument document = documentProvider.getDocument((Object)element);
            return document;
        }
        return null;
    }

    @Override
    public String getPreferredPerspectiveId() {
        return null;
    }

    public void onFileLoading(IFile file) {
        this.setPartName(file.getName());
    }

    public void onInputLoading(IEditorInput input) {
        this.setPartName(input.getName());
    }

    public void switchToSourceEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderEditor.this.updatedDesignPage();
                RiderEditor.this.setActiveEditor((IEditorPart)RiderEditor.this.getSourceEditor());
                RiderEditor.this.setActivePage(1);
                RiderEditor.this.getSourceEditor().setFocus();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("preferIdAsLabelPreference")) {
            this.designEditor.update();
        } else if (event.getProperty().equals("diagramLayoutOrientationPreference")) {
            this.designEditor.autoLayoutRoute();
        } else if (event.getProperty().equals("diagramGridVisibilityPreference")) {
            DiagramUtils.setGridVisible((Boolean)event.getNewValue());
        } else if (event.getProperty().equals("diagramTextColorPreference") || event.getProperty().equals("diagramConnectionColorPreference") || event.getProperty().equals("diagramFigureBackgroundColorPreference") || event.getProperty().equals("diagramFigureForegroundColorPreference")) {
            this.designEditor.refresh();
        } else if (event.getProperty().equals("diagramGridColorPreference")) {
            this.designEditor.setupGridVisibility();
        }
    }
}

