/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.add;

import com.fusesource.rider.editor.provider.ImageProvider;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.editor.utils.ImageUtils;
import com.fusesource.rider.editor.utils.StyleUtil;
import com.fusesource.rider.model.AbstractNode;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class AddNodeFeature
extends AbstractAddShapeFeature {
    public static final int INVISIBLE_RECT_RIGHT = 6;
    public static final int VERTICAL_SPACER = 5;
    public static final int ROUNDED_RECTANGLE_WIDTH = 10;
    public static final int ROUNDED_RECTANGLE_HEIGHT = 10;
    public static final int SHADOW_WIDTH = 1;
    public static final int SHADOW_HEIGHT = 2;
    public static final int TOP_BOTTOM_SPACER = 1;
    private static int TEXT_LABEL_SIZE = 20;

    public AddNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        Object newObject = context.getNewObject();
        return newObject instanceof AbstractNode && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        AbstractNode addedClass = (AbstractNode)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        String label = DiagramUtils.filterFigureLabel(addedClass.getDisplayText());
        Font f = StyleUtil.getStyleForCamelText(this.getDiagram()).getFont();
        IDimension fd = GraphitiUi.getUiLayoutService().calculateTextSize(label, f);
        Dimension d = ImageUtils.getImageSize(addedClass.getIconName());
        int width = context.getWidth() < 100 ? 100 : context.getWidth();
        int height = context.getHeight() < 80 ? 80 : context.getHeight();
        width = Math.max(width, fd.getWidth() + 6);
        TEXT_LABEL_SIZE = fd.getHeight() + 5;
        if (d.width > 0 && d.width > width) {
            width = d.width + 6;
        }
        if (d.height > 0) {
            height = d.height + TEXT_LABEL_SIZE;
        }
        IGaService gaService = Graphiti.getGaService();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + 6 + 1, (height += 2) + 2);
        RoundedRectangle shadowRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 10, 10);
        shadowRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)invisibleRectangle);
        shadowRectangle.setStyle(StyleUtil.getShadowStyleForCamelClass(this.getDiagram()));
        gaService.setLocationAndSize((GraphicsAlgorithm)shadowRectangle, 1, 2, width, height);
        RoundedRectangle roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 10, 10);
        roundedRectangle.setParentGraphicsAlgorithm((GraphicsAlgorithm)invisibleRectangle);
        roundedRectangle.setStyle(StyleUtil.getStyleForCamelClass(this.getDiagram()));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, 0, 0, width, height);
        Shape shape = peCreateService.createShape(containerShape, false);
        Image image = gaService.createImage((GraphicsAlgorithmContainer)shape, ImageProvider.getKeyForLargeIcon(addedClass.getIconName()));
        gaService.setLocationAndSize((GraphicsAlgorithm)image, 0, 1, width, height - TEXT_LABEL_SIZE + 5);
        if (addedClass.eResource() == null) {
            this.getDiagram().eResource().getContents().add((Object)addedClass);
        }
        this.link((PictogramElement)containerShape, addedClass);
        shape = peCreateService.createShape(containerShape, false);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)shape, label);
        Style style = StyleUtil.getStyleForCamelText(this.getDiagram());
        text.setStyle(style);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        text.setFont(style.getFont());
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 0, height - TEXT_LABEL_SIZE, width, TEXT_LABEL_SIZE);
        IDirectEditingInfo directEditingInfo = this.getFeatureProvider().getDirectEditingInfo();
        directEditingInfo.setMainPictogramElement((PictogramElement)containerShape);
        directEditingInfo.setPictogramElement((PictogramElement)shape);
        directEditingInfo.setGraphicsAlgorithm((GraphicsAlgorithm)text);
        peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }
}

