/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.create;

import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.provider.PaletteCategoryItemProvider;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Flow;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CreateFlowFeature
extends AbstractCreateConnectionFeature
implements PaletteCategoryItemProvider {
    public CreateFlowFeature(IFeatureProvider fp) {
        super(fp, "Flow", "Create Flow");
    }

    @Override
    public PaletteCategoryItemProvider.CATEGORY_TYPE getCategoryType() {
        String name = this.getCategoryName();
        return PaletteCategoryItemProvider.CATEGORY_TYPE.getCategoryType(name);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        AbstractNode source = this.getNode(context.getSourceAnchor());
        AbstractNode target = this.getNode(context.getTargetAnchor());
        if (target != null && source != target) {
            return source == null || source.canConnectTo(target);
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return this.getNode(context.getSourceAnchor()) != null;
    }

    public String getCreateImageId() {
        return "com.fusesource.demo.icons.flow";
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    public Connection create(ICreateConnectionContext context) {
        Connection newConnection = null;
        AbstractNode source = this.getNode(context.getSourceAnchor());
        AbstractNode target = this.getNode(context.getTargetAnchor());
        if (target != null) {
            if (source == null) {
                RouteSupport route;
                RiderDesignEditor editor = RiderDesignEditor.toRiderDesignEditor(this.getDiagramEditor());
                if (editor != null && (route = editor.getSelectedRoute()) != null) {
                    route.addChild(target);
                }
            } else {
                EReference eReference = this.createEReference(source, target);
                AddConnectionContext addContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
                addContext.setNewObject((Object)eReference);
                newConnection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                this.linkBOs(source, target);
            }
        }
        return newConnection;
    }

    private AbstractNode getNode(Anchor anchor) {
        Object obj;
        if (anchor != null && (obj = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof AbstractNode) {
            return (AbstractNode)obj;
        }
        return null;
    }

    private EReference createEReference(AbstractNode source, AbstractNode target) {
        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
        eReference.setName("new EReference");
        eReference.setEType((EClassifier)target);
        eReference.setLowerBound(0);
        eReference.setUpperBound(1);
        source.getEStructuralFeatures().add((Object)eReference);
        return eReference;
    }

    private Flow linkBOs(AbstractNode source, AbstractNode target) {
        return new Flow(source, target);
    }

    @Override
    public String getCategoryName() {
        return null;
    }
}

