/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.custom;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.commands.DiagramOperations;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.features.create.CreateFlowFeature;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.impl.DiagramImpl;
import org.eclipse.swt.widgets.Display;

public class CreateNodeConnectionFeature
extends AbstractCustomFeature {
    private Class<? extends AbstractNode> clazz;

    public CreateNodeConnectionFeature(IFeatureProvider fp, Class<? extends AbstractNode> clazz) {
        super(fp);
        this.clazz = clazz;
    }

    public String getDescription() {
        return "Adds and connects a node to the current node";
    }

    public String getName() {
        return "&Add Node";
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(final ICustomContext context) {
        AbstractNode node = null;
        try {
            node = this.createNode();
        }
        catch (Exception exception) {
            return;
        }
        if (node instanceof RouteSupport) {
            DiagramOperations.addNewRoute(Activator.getDiagramEditor());
            return;
        }
        boolean firstNode = context.getPictogramElements().length == 1 && context.getPictogramElements()[0] instanceof DiagramImpl;
        int x = context.getPictogramElements().length > 0 ? context.getPictogramElements()[0].getGraphicsAlgorithm().getX() + 150 : 150;
        int y = context.getPictogramElements().length > 0 ? context.getPictogramElements()[0].getGraphicsAlgorithm().getY() : 150;
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)node);
        addContext.setLocation(x, y);
        addContext.setTargetContainer((ContainerShape)this.getDiagram());
        IAddFeature addFeature = this.getFeatureProvider().getAddFeature((IAddContext)addContext);
        PictogramElement newNode = null;
        if (addFeature.canAdd((IAddContext)addContext) && (newNode = addFeature.add((IAddContext)addContext)) != null) {
            Activator.getDefault();
            RouteSupport selectedRoute = Activator.getDiagramEditor().getSelectedRoute();
            if (selectedRoute != null) {
                selectedRoute.addChild(node);
            }
            if (this.getDiagram() != null) {
                this.getDiagram().eResource().getContents().add((Object)node);
            }
        }
        PictogramElement srcState = null;
        PictogramElement destState = null;
        if (!firstNode) {
            CreateFlowFeature createFeature = new CreateFlowFeature(this.getFeatureProvider());
            CreateConnectionContext connectContext = new CreateConnectionContext();
            srcState = context.getPictogramElements()[0];
            if (srcState == (destState = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)node))) {
                System.out.println("Should not be the same element for different nodes: " + context.getPictogramElements()[0].getLink().getBusinessObjects().get(0) + " and " + node);
            }
            connectContext.setSourcePictogramElement(srcState);
            connectContext.setTargetPictogramElement(destState);
            Anchor srcAnchor = DiagramUtils.getAnchor(srcState);
            Anchor destAnchor = DiagramUtils.getAnchor(destState);
            if (destAnchor != null) {
                connectContext.setSourceAnchor(srcAnchor);
                connectContext.setTargetAnchor(destAnchor);
                if (createFeature.canCreate((ICreateConnectionContext)connectContext)) {
                    createFeature.execute((IContext)connectContext);
                }
            }
        }
        final PictogramElement dState = destState;
        final PictogramElement nNode = newNode;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                RiderDesignEditor ed = Activator.getDiagramEditor();
                DiagramOperations.layoutDiagram(ed);
                if (dState != null) {
                    ed.setPictogramElementForSelection(dState);
                } else if (nNode != null) {
                    ed.setPictogramElementForSelection(nNode);
                } else {
                    ed.setPictogramElementForSelection(context.getPictogramElements()[0]);
                }
                ed.refresh();
            }
        });
    }

    protected AbstractNode createNode() throws Exception {
        return this.clazz.newInstance();
    }
}

