/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.delete;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Flow;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.sus.Activator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EReferenceImpl;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;

public class DeleteNodeFeature
extends DefaultDeleteFeature {
    public DeleteNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void preDelete(IDeleteContext context) {
        super.preDelete(context);
        PictogramElement pe = context.getPictogramElement();
        Object[] businessObjectsForPictogramElement = this.getAllBusinessObjectsForPictogramElement(pe);
        if (businessObjectsForPictogramElement != null && businessObjectsForPictogramElement.length > 0) {
            Object bo = businessObjectsForPictogramElement[0];
            if (bo instanceof Flow) {
                this.deleteFlowFromModel((Flow)bo);
            } else if (bo instanceof AbstractNode) {
                this.deleteBOFromModel((AbstractNode)bo);
            } else if (bo instanceof EReferenceImpl) {
                EReferenceImpl eimpl = (EReferenceImpl)bo;
                EClassifier eType = eimpl.getEType();
                if (eType instanceof AbstractNode) {
                    AbstractNode target = (AbstractNode)eType;
                    System.out.println("==== trying to zap the target: " + target);
                    EObject eContainer = eimpl.eContainer();
                    if (eContainer instanceof AbstractNode) {
                        AbstractNode source = (AbstractNode)eContainer;
                        System.out.println("==== trying to source: " + source + " -> target: " + target);
                        source.removeConnection(target);
                    }
                }
            } else {
                Activator.getLogger().warning("Cannot figure out Node or Flow from BO: " + bo);
            }
        }
    }

    private void deleteBOFromModel(AbstractNode nodeToRemove) {
        if (nodeToRemove == null || nodeToRemove instanceof RouteContainer) {
            return;
        }
        nodeToRemove.detach();
    }

    private void deleteFlowFromModel(Flow bo) {
        bo.detach();
    }
}

