/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.other;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.generated.Bean;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DirectEditNodeFeature
extends AbstractDirectEditingFeature {
    public DirectEditNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return bo instanceof AbstractNode && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        AbstractNode node = (AbstractNode)this.getBusinessObjectForPictogramElement(pe);
        return node.getDisplayText();
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value.length() < 1) {
            return "Please enter any text as class name.";
        }
        if (value.contains(" ")) {
            return "Spaces are not allowed in class names.";
        }
        if (value.contains("\n")) {
            return "Line breakes are not allowed in class names.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof Endpoint) {
            Endpoint ep = (Endpoint)this.getBusinessObjectForPictogramElement(pe);
            ep.setUri(value);
        } else if (bo instanceof Bean) {
            Bean bean = (Bean)this.getBusinessObjectForPictogramElement(pe);
            bean.setRef(value);
        }
        this.updatePictogramElement((PictogramElement)((Shape)pe).getContainer());
    }
}

