/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.other;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class LayoutNodeFeature
extends AbstractLayoutFeature {
    private static final int MIN_HEIGHT = 30;
    private static final int MIN_WIDTH = 50;

    public LayoutNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (!(pe instanceof ContainerShape)) {
            return false;
        }
        EList businessObjects = pe.getLink().getBusinessObjects();
        return businessObjects.size() == 1 && businessObjects.get(0) instanceof EClass;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        GraphicsAlgorithm rectangle = (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0);
        if (containerGa.getHeight() < 30) {
            containerGa.setHeight(30);
            anythingChanged = true;
        }
        if (rectangle.getHeight() != containerGa.getHeight()) {
            rectangle.setHeight(containerGa.getHeight());
            anythingChanged = true;
        }
        if (containerGa.getWidth() < 50) {
            containerGa.setWidth(50);
            anythingChanged = true;
        }
        int rectangleWidth = containerGa.getWidth() - 6;
        if (rectangle.getWidth() != rectangleWidth) {
            rectangle.setWidth(rectangleWidth);
            anythingChanged = true;
        }
        for (Shape shape : containerShape.getChildren()) {
            GraphicsAlgorithm graphicsAlgorithm = shape.getGraphicsAlgorithm();
            IGaService gaService = Graphiti.getGaService();
            IDimension size = gaService.calculateSize(graphicsAlgorithm);
            if (rectangleWidth == size.getWidth()) continue;
            gaService.setWidth(graphicsAlgorithm, rectangleWidth);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

