/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.features.other;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.commands.DiagramOperations;
import com.fusesource.rider.editor.utils.DiagramUtils;
import com.fusesource.rider.editor.utils.StyleUtil;
import com.fusesource.rider.model.AbstractNode;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.services.GraphitiUi;

public class UpdateNodeFeature
extends AbstractUpdateFeature {
    public UpdateNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof AbstractNode;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        String pictogramName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            for (Shape shape : cs.getChildren()) {
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                pictogramName = text.getValue();
            }
        }
        String businessName = null;
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            AbstractNode eClass = (AbstractNode)bo;
            businessName = DiagramUtils.filterFigureLabel(eClass.getDisplayText());
        }
        boolean bl = updateNameNeeded = pictogramName == null && businessName != null || pictogramName != null && !pictogramName.equals(businessName);
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)"Name is out of date");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        String businessName = null;
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            AbstractNode eClass = (AbstractNode)bo;
            businessName = DiagramUtils.filterFigureLabel(eClass.getDisplayText());
        }
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape cs = (ContainerShape)pictogramElement;
            int oldWidth = cs.getGraphicsAlgorithm().getWidth();
            Font f = StyleUtil.getStyleForCamelText(this.getDiagram()).getFont();
            IDimension fd = GraphitiUi.getUiLayoutService().calculateTextSize(businessName, f);
            int newWidth = fd.getWidth() + 6;
            if (newWidth > oldWidth) {
                pictogramElement.getGraphicsAlgorithm().setWidth(newWidth);
                for (GraphicsAlgorithm g : pictogramElement.getGraphicsAlgorithm().getGraphicsAlgorithmChildren()) {
                    g.setWidth(newWidth);
                }
            }
            for (Shape shape : cs.getChildren()) {
                if (newWidth > oldWidth) {
                    shape.getGraphicsAlgorithm().setWidth(newWidth);
                }
                if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
                Text text = (Text)shape.getGraphicsAlgorithm();
                text.setValue(businessName);
                DiagramOperations.layoutDiagram(Activator.getDiagramEditor());
                return true;
            }
        }
        return false;
    }
}

