/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.handlers;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.EditorMessages;
import com.fusesource.rider.editor.commands.DiagramOperations;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public class DeleteRouteAction
extends Action {
    public static final String DELETE_ROUTE_COMMAND_ID = "com.fusesource.rider.editor.commands.deleteRouteCommand";
    private RouteSupport selectedRoute;

    public void run() {
        RiderDesignEditor editor = Activator.getDiagramEditor();
        DiagramOperations.deleteRoute(editor, this.getSelectedRoute());
        if (editor.getModel().getChildren().size() < 1) {
            editor.addNewRoute();
            editor.getEditor().recreateDesignPage();
        }
    }

    public String getId() {
        return DELETE_ROUTE_COMMAND_ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
    }

    public String getDescription() {
        return EditorMessages.deleteRouteCommandDescription;
    }

    public String getText() {
        return EditorMessages.deleteRouteCommandLabel;
    }

    public String getToolTipText() {
        return EditorMessages.deleteRouteCommandDescription;
    }

    public void setSelectedRoute(RouteSupport selectedRoute) {
        this.selectedRoute = selectedRoute;
    }

    public RouteSupport getSelectedRoute() {
        return this.selectedRoute;
    }
}

