/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.outline;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.fixed.FixedScrollableThumbnail;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public class CamelContextOutlinePage
extends ContentOutlinePage
implements IAdaptable,
IPropertyListener {
    private static final int ID_OUTLINE = 0;
    private static final int ID_THUMBNAIL = 1;
    private GraphicalViewer _graphicalViewer;
    private ActionRegistry _actionRegistry;
    private EditDomain _editDomain;
    private KeyHandler _keyHandler;
    private Object _zoomManagerAdapter;
    private SelectionSynchronizer _selectionSynchronizer;
    private DiagramEditor _diagramEditor;
    private FixedScrollableThumbnail _thumbnail;
    private IAction _showOutlineAction;
    private IAction _showOverviewAction;
    private PageBook _pageBook;
    private Control _outline;
    private Canvas _overview;

    public CamelContextOutlinePage(EditPartViewer viewer, GraphicalViewer graphicalViewer, ActionRegistry actionRegistry, EditDomain editDomain, KeyHandler keyHandler, Object zoomManagerAdapter, SelectionSynchronizer selectionSynchronizer, DiagramEditor diagramEditor) {
        super(viewer);
        this._graphicalViewer = graphicalViewer;
        this._actionRegistry = actionRegistry;
        this._editDomain = editDomain;
        this._keyHandler = keyHandler;
        this._zoomManagerAdapter = zoomManagerAdapter;
        this._selectionSynchronizer = selectionSynchronizer;
        this._diagramEditor = diagramEditor;
    }

    public void initContents() {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars actionBars = pageSite.getActionBars();
        this.registerGlobalActionHandler(actionBars, ActionFactory.UNDO.getId());
        this.registerGlobalActionHandler(actionBars, ActionFactory.REDO.getId());
        this.registerGlobalActionHandler(actionBars, ActionFactory.COPY.getId());
        this.registerGlobalActionHandler(actionBars, ActionFactory.PASTE.getId());
        this.registerGlobalActionHandler(actionBars, ActionFactory.PRINT.getId());
        this.registerGlobalActionHandler(actionBars, ActionFactory.SAVE_AS.getId());
        actionBars.updateActionBars();
    }

    public void createControl(Composite parent) {
        this._pageBook = new PageBook(parent, 0);
        this._outline = this.getViewer().createControl((Composite)this._pageBook);
        this._overview = new Canvas((Composite)this._pageBook, 0);
        this._pageBook.showPage(this._outline);
        this.createOutlineViewer();
        this._selectionSynchronizer.addViewer(this.getViewer());
        this._diagramEditor.addPropertyListener((IPropertyListener)this);
        this.initContents();
    }

    public void dispose() {
        this._selectionSynchronizer.removeViewer(this.getViewer());
        this._diagramEditor.removePropertyListener((IPropertyListener)this);
        if (this._thumbnail != null) {
            this._thumbnail.deactivate();
        }
        super.dispose();
    }

    public Control getControl() {
        return this._pageBook;
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return this._zoomManagerAdapter;
        }
        return null;
    }

    public void propertyChanged(Object source, int propId) {
        this.refresh();
    }

    protected void showPage(int id) {
        if (id == 0) {
            this._showOutlineAction.setChecked(true);
            this._showOverviewAction.setChecked(false);
            this._pageBook.showPage(this._outline);
        } else if (id == 1) {
            if (this._thumbnail == null) {
                this.createThumbnailViewer();
            }
            this._showOutlineAction.setChecked(false);
            this._showOverviewAction.setChecked(true);
            this._pageBook.showPage((Control)this._overview);
        }
    }

    protected void createOutlineViewer() {
        this.getViewer().setEditDomain(this._editDomain);
        this.getViewer().setKeyHandler(this._keyHandler);
        ContextMenuProvider contextMenuProvider = this.createContextMenuProvider();
        if (contextMenuProvider != null) {
            this.getViewer().setContextMenu((MenuManager)contextMenuProvider);
        }
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this._showOutlineAction = new Action(){

            public void run() {
                CamelContextOutlinePage.this.showPage(0);
            }
        };
        this._showOutlineAction.setImageDescriptor(GraphitiUi.getImageService().getImageDescriptorForId("com.fusesource.demo.icons.outline.tree"));
        tbm.add(this._showOutlineAction);
        this._showOverviewAction = new Action(){

            public void run() {
                CamelContextOutlinePage.this.showPage(1);
            }
        };
        this._showOverviewAction.setImageDescriptor(GraphitiUi.getImageService().getImageDescriptorForId("com.fusesource.demo.icons.outline.thumbnail"));
        tbm.add(this._showOverviewAction);
        this.showPage(0);
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return null;
    }

    protected void createThumbnailViewer() {
        LightweightSystem lws = new LightweightSystem(this._overview);
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this._graphicalViewer.getRootEditPart();
        this._thumbnail = new FixedScrollableThumbnail((Viewport)rootEditPart.getFigure());
        this._thumbnail.setBorder((Border)new MarginBorder(3));
        this._thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
        lws.setContents((IFigure)this._thumbnail);
    }

    private void registerGlobalActionHandler(IActionBars actionBars, String id) {
        IAction action = this._actionRegistry.getAction((Object)id);
        if (action != null) {
            actionBars.setGlobalActionHandler(id, action);
        }
    }

    void refresh() {
        EditPartViewer viewer = this.getViewer();
        EditPart contents = viewer.getContents();
        if (contents != null) {
            contents.refresh();
        }
    }
}

