/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.outline;

import com.fusesource.rider.commons.ui.Trees;
import com.fusesource.rider.editor.AbstractNodes;
import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.editor.INodeViewer;
import com.fusesource.rider.editor.editor.ModelChangeListener;
import com.fusesource.rider.editor.editor.NodeSelectionSupport;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.editor.RiderEditorContextMenuProvider;
import com.fusesource.rider.editor.outline.tree.AbstractNodeTreeEditPart;
import com.fusesource.rider.editor.outline.tree.RouteTreeEditPartFactory;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.graphiti.ui.internal.util.gef.ScalableRootEditPartAnimated;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

public class RiderOutlinePage
extends ContentOutlinePage
implements INodeViewer,
ModelChangeListener {
    private RiderDesignEditor editor;
    private ScrollableThumbnail thumbnail;
    private DisposeListener disposeListener;
    private SashForm sash;
    private RouteTreeEditPartFactory editPartFactory;
    private NodeSelectionSupport nodeListener = new NodeSelectionSupport();
    private RouteSupport previousSelection;

    public RiderOutlinePage(RiderDesignEditor editor) {
        super((EditPartViewer)new TreeViewer());
        this.editor = editor;
        this.editPartFactory = new RouteTreeEditPartFactory(this);
        this.editor.addModelChangeListener(this);
    }

    @Override
    public AbstractNode getSelectedNode() {
        return this.nodeListener.getSelectedNode();
    }

    @Override
    public void setSelectedNode(AbstractNode newSelection) {
        if (newSelection != null) {
            AbstractNodeTreeEditPart selectEditPart = AbstractNodeTreeEditPart.findEditPart(newSelection, (EditPart)this.getViewer().getRootEditPart());
            if (selectEditPart != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectEditPart));
            } else {
                Activator.getLogger().error("Could not find editPart for selection: " + newSelection, (Throwable)new Exception());
            }
        }
    }

    public void createControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.getViewer().createControl((Composite)this.sash);
        this.getViewer().setEditDomain((EditDomain)this.editor.getEditDomain());
        this.getViewer().setEditPartFactory((EditPartFactory)this.editPartFactory);
        this.onModelChange();
        this.editor.getSelectionSynchronizerInternal().addViewer(this.getViewer());
        Canvas canvas = new Canvas((Composite)this.sash, 2048);
        LightweightSystem lws = new LightweightSystem(canvas);
        RootEditPart rootEditPart = this.editor.getGraphicalViewer().getRootEditPart();
        if (rootEditPart instanceof ScalableRootEditPartAnimated) {
            ScalableRootEditPartAnimated diagramEditPart = (ScalableRootEditPartAnimated)rootEditPart;
            IFigure figure = diagramEditPart.getFigure();
            this.thumbnail = new ScrollableThumbnail((Viewport)figure);
            IFigure source = diagramEditPart.getLayer((Object)"Printable Layers");
            this.thumbnail.setSource(source);
            lws.setContents((IFigure)this.thumbnail);
        } else if (rootEditPart instanceof ScalableRootEditPart) {
            this.thumbnail = new ScrollableThumbnail((Viewport)((ScalableRootEditPart)rootEditPart).getFigure());
            this.thumbnail.setSource(((ScalableRootEditPart)rootEditPart).getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
        }
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RiderOutlinePage.this.thumbnail != null) {
                    RiderOutlinePage.this.thumbnail.deactivate();
                    RiderOutlinePage.this.thumbnail = null;
                }
            }
        };
        this.editor.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        TreeViewer viewer = this.getTreeViewer();
        final IWorkbenchPart part = null;
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                RiderOutlinePage.this.nodeListener.selectionChanged(part, selection);
                AbstractNode node = AbstractNodes.getSelectedNode(selection);
                RouteSupport route = AbstractNodes.getRoute(node);
                if (route != null && route != RiderOutlinePage.this.previousSelection) {
                    RiderOutlinePage.this.previousSelection = route;
                    if (RiderOutlinePage.this.editor.getSelectedRoute() != route) {
                        RiderOutlinePage.this.editor.setSelectedRoute(route);
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RiderOutlinePage.this.setFocus();
                        }
                    });
                }
            }
        });
        final Tree tree = (Tree)viewer.getControl();
        new DefaultToolTip((Control)tree){

            protected String getText(Event event) {
                TreeItem item = tree.getItem(new Point(event.x, event.y));
                if (item != null) {
                    Object data = item.getData();
                    AbstractNode node = AbstractNodes.toAbstractNode(item.getData());
                    if (node != null) {
                        return node.getDisplayToolTip();
                    }
                    if (data instanceof AbstractNodeTreeEditPart) {
                        AbstractNodeTreeEditPart nodeTree = (AbstractNodeTreeEditPart)data;
                        return nodeTree.getToolTip();
                    }
                }
                return super.getText(event);
            }
        };
    }

    @Override
    public void onModelChange() {
        RouteContainer model = this.editor.getModel();
        if (model != null) {
            Tree tree = this.getTree();
            if (tree == null) {
                System.out.println("Warning - attempt to set the model when no tree!");
            } else {
                this.getViewer().setContents((Object)model);
                Trees.expandAll((Tree)tree);
            }
        }
    }

    public Tree getTree() {
        return (Tree)this.getTreeViewer().getControl();
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        IActionBars bars = this.getSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.editor.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        bars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.editor.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.editor.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        bars.updateActionBars();
        this.getViewer().setKeyHandler(this.editor.getKeyHandler());
        RiderEditorContextMenuProvider provider = new RiderEditorContextMenuProvider(this.editor, this, this.getViewer(), this.editor.getActionRegistry());
        this.getViewer().setContextMenu((MenuManager)provider);
    }

    public Control getControl() {
        return this.sash;
    }

    public void dispose() {
        this.editor.removeModelChangeListener(this);
        this.editor.getSelectionSynchronizerInternal().removeViewer(this.getViewer());
        if (this.editor.getGraphicalViewer().getControl() != null && !this.editor.getGraphicalViewer().getControl().isDisposed()) {
            this.editor.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
        }
        super.dispose();
    }
}

