/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.outline.tree;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.outline.tree.ContainerTreeEditPart;
import com.fusesource.rider.model.AbstractNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;

public class AbstractNodeTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    protected static final List<AbstractNode> EMPTY_LIST = new ArrayList<AbstractNode>();
    protected static final Set<String> treeRelationshipPropertyNames = new HashSet<String>(Arrays.asList("Route.ChildAdded", "Route.ChildRemoved", "AbstractNode.SourceConn", "AbstractNode.TargetConn"));
    private Image image;

    public static AbstractNodeTreeEditPart findEditPart(AbstractNode node, EditPart part) {
        AbstractNodeTreeEditPart nodeEditPart;
        AbstractNode modelNode;
        if (part instanceof AbstractNodeTreeEditPart && ObjectHelper.equal((Object)node, (Object)(modelNode = (nodeEditPart = (AbstractNodeTreeEditPart)part).getModelNode()))) {
            return nodeEditPart;
        }
        List children = part.getChildren();
        for (EditPart childPart : children) {
            AbstractNodeTreeEditPart answer = AbstractNodeTreeEditPart.findEditPart(node, childPart);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    public void activate() {
        super.activate();
        this.getModelNode().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModelNode().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    public AbstractNode getModelNode() {
        return (AbstractNode)this.getModel();
    }

    public void refreshVisuals() {
        AbstractNode model = this.getModelNode();
        String displayText = model.getDisplayText();
        if (displayText == null) {
            Activator.getLogger().warning("No display text for " + model + " of type: " + model.getClass().getCanonicalName());
        } else {
            this.setWidgetText(displayText);
        }
        this.setWidgetImage(this.getImage());
    }

    protected List<AbstractNode> getModelChildren() {
        AbstractNode node = (AbstractNode)this.getModel();
        return node.getOutputs();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null) {
            List ch;
            String propertyName = evt.getPropertyName();
            if (this.getModelNode().isPropertyName(propertyName)) {
                this.refreshVisuals();
            } else if (propertyName != null && (ch = this.getChildren()) != null && this.isTreeRelationshipPropertyName(propertyName)) {
                this.refreshChildren();
                EditPart parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof ContainerTreeEditPart) {
                        ((ContainerTreeEditPart)parent).refreshChildren();
                        break;
                    }
                    parent = parent.getParent();
                }
            }
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.image = this.getModelNode().getSmallImage();
        this.refreshVisuals();
    }

    protected Image getImage() {
        AbstractNode node = this.getModelNode();
        if (this.image == null && node != null) {
            this.image = node.getSmallImage();
        }
        return this.image;
    }

    protected boolean isTreeRelationshipPropertyName(String propertyName) {
        return treeRelationshipPropertyNames.contains(propertyName);
    }

    public String getToolTip() {
        AbstractNode node = (AbstractNode)this.getModel();
        return node.getDisplayToolTip();
    }
}

