/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.outline.tree;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.outline.RiderOutlinePage;
import com.fusesource.rider.editor.outline.tree.AbstractNodeTreeEditPart;
import com.fusesource.rider.editor.outline.tree.ContainerTreeEditPart;
import com.fusesource.rider.editor.outline.tree.GenericTreeEditPart;
import com.fusesource.rider.editor.outline.tree.RouteTreeEditPart;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class RouteTreeEditPartFactory
implements EditPartFactory {
    private final RiderOutlinePage owner;

    public RouteTreeEditPartFactory(RiderOutlinePage owner) {
        this.owner = owner;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        AbstractNodeTreeEditPart part = null;
        part = model instanceof RouteSupport ? new RouteTreeEditPart() : (model instanceof RouteContainer ? new ContainerTreeEditPart() : new GenericTreeEditPart());
        if (part != null) {
            part.setModel(model);
            Tree widget = null;
            if (context != null) {
                RootEditPart root;
                EditPartViewer viewer = context.getViewer();
                if (viewer == null && (root = context.getRoot()) != null) {
                    viewer = root.getViewer();
                }
                if (viewer != null) {
                    widget = viewer.getControl();
                }
            }
            if (widget == null) {
                widget = this.owner.getTree();
            }
            if (widget != null) {
                part.setWidget((Widget)widget);
            } else {
                Activator.getLogger().debug("Could not find widget yet for part " + part);
            }
        }
        System.err.println("Created EditPart for Object: " + model + "[" + model.hashCode() + "] with context: " + (context != null ? context.getModel() : context) + "[" + (context != null && context.getModel() != null ? Integer.valueOf(context.getModel().hashCode()) : "null") + "]");
        return part;
    }
}

