/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.propertysheet;

import com.fusesource.rider.editor.EditorMessages;
import com.fusesource.rider.editor.propertysheet.NodeSectionSupport;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Endpoint;
import java.net.URL;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DocumentationSection
extends NodeSectionSupport {
    private FormToolkit toolkit;
    private Form form;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
        }
    };
    private Composite parent;
    private Browser browser;

    @Override
    protected void onNodeChanged(AbstractNode node) {
        this.node = node;
        this.showDocumentationPage();
    }

    @Override
    public void aboutToBeShown() {
        this.showDocumentationPage();
        super.aboutToBeShown();
    }

    protected void showDocumentationPage() {
        if (this.node != null) {
            int idx;
            Endpoint endpoint;
            String uri;
            boolean loadedPage = false;
            if (this.node instanceof Endpoint && (uri = (endpoint = (Endpoint)this.node).getUri()) != null && (idx = uri.indexOf(58)) > 0) {
                String scheme = uri.substring(0, idx);
                String contextId = "com.fusesource.rider.editor." + scheme;
                loadedPage = this.resolvePage(contextId, true);
            }
            if (!loadedPage) {
                String text = this.node.getDocumentationFileName();
                uri = "com.fusesource.rider.editor.allEIPs";
                if (text != null) {
                    uri = "com.fusesource.rider.editor." + text;
                }
                this.resolvePage(uri, false);
            }
        }
    }

    protected boolean resolvePage(String contextId, boolean endpoint) {
        IContext context = HelpSystem.getContext((String)contextId);
        if (context == null) {
            context = endpoint ? HelpSystem.getContext((String)"com.fusesource.rider.editor.endpoint") : HelpSystem.getContext((String)"com.fusesource.rider.editor.allEIPs");
        }
        String helpUrl = context.getRelatedTopics()[0].getHref();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        URL url = helpSystem.resolve(helpUrl, true);
        boolean answer = this.browser.setUrl(url.toExternalForm());
        return answer;
    }

    public void refresh() {
    }

    public void createControls(final Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        this.parent = parent;
        this.toolkit = new FormToolkit(parent.getDisplay());
        super.createControls(parent, aTabbedPropertySheetPage);
        if (this.form != null && !this.form.isDisposed()) {
            try {
                this.form.dispose();
            }
            catch (Exception exception) {}
        }
        this.form = null;
        if (parent.isDisposed()) {
            return;
        }
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.form = this.toolkit.createForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        this.form.setText(EditorMessages.propertiesDocumentationTitle);
        this.toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite sbody = this.form.getBody();
        this.browser = new Browser(sbody, 0);
        GridData data = new GridData(1808);
        this.browser.setLayoutData((Object)data);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        URL url = helpSystem.resolve("com.fusesource.rider.help/index.html", true);
        this.browser.setUrl(url.toExternalForm());
        this.form.layout(true, true);
        parent.layout(true, true);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DocumentationSection.this.form != null && !DocumentationSection.this.form.isDisposed()) {
                    DocumentationSection.this.form.layout(true, true);
                }
                if (parent != null && !parent.isDisposed()) {
                    parent.layout(true, true);
                }
            }
        });
    }
}

