/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.propertysheet;

import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.ui.form.FormSupport;
import com.fusesource.rider.editor.propertysheet.SetHeaderBeanView;
import org.apache.camel.model.SetHeaderDefinition;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.fusesource.camel.rider.util.Languages;

public class SetHeaderForm
extends FormSupport {
    private final SetHeaderDefinition definition;
    private Text headerNameField;
    private Text expressionField;
    private ComboViewer languageCombo;
    private SetHeaderBeanView beanView;
    private Refreshable refreshable;

    public SetHeaderForm(SetHeaderDefinition definition, Refreshable refreshable) {
        this.definition = definition;
        this.refreshable = refreshable;
        this.beanView = new SetHeaderBeanView(definition);
    }

    public SetHeaderDefinition getDefinition() {
        return this.definition;
    }

    public void setFocus() {
        if (this.headerNameField != null) {
            this.headerNameField.setFocus();
        }
    }

    protected void createTextFields(Composite parent) {
        Composite panel = this.getForm().getBody();
        panel.setLayout((Layout)new GridLayout(2, false));
        this.headerNameField = this.createBeanPropertyTextField(panel, (Object)this.beanView, "headerName", "Header", "Name of the header to set");
        this.expressionField = this.createBeanPropertyTextField(panel, (Object)this.beanView, "expression", "Expression", "Expression used to set the header value");
        this.languageCombo = this.createBeanPropertyCombo(panel, (Object)this.beanView, "language", "Language", "Expression language to use", 8);
        this.languageCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.languageCombo.setInput((Object)new Languages().languageArray());
        this.languageCombo.setSelection((ISelection)new StructuredSelection((Object)this.beanView.getLanguage()));
    }

    public void okPressed() {
        this.beanView.update();
        if (this.refreshable != null) {
            this.refreshable.refresh();
        }
    }
}

