/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.provider;

import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.editor.AbstractNodes;
import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.editor.features.add.AddFlowFeature;
import com.fusesource.rider.editor.features.add.AddNodeFeature;
import com.fusesource.rider.editor.features.create.CreateBeanFigureFeature;
import com.fusesource.rider.editor.features.create.CreateEndpointFigureFeature;
import com.fusesource.rider.editor.features.create.CreateFlowFeature;
import com.fusesource.rider.editor.features.custom.LayoutDiagramFeature;
import com.fusesource.rider.editor.features.delete.DeleteNodeFeature;
import com.fusesource.rider.editor.features.delete.RemoveNodeFeature;
import com.fusesource.rider.editor.features.other.CopyNodeFeature;
import com.fusesource.rider.editor.features.other.LayoutNodeFeature;
import com.fusesource.rider.editor.features.other.MoveNodeFeature;
import com.fusesource.rider.editor.features.other.PasteNodeFeature;
import com.fusesource.rider.editor.features.other.ResizeNodeFeature;
import com.fusesource.rider.editor.features.other.UpdateNodeFeature;
import com.fusesource.rider.editor.provider.generated.AddNodeMenuFactory;
import com.fusesource.rider.editor.provider.generated.ProviderHelper;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.generated.Bean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICopyFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;

public class CamelFeatureProvider
extends DefaultFeatureProvider {
    private AddNodeMenuFactory menuFactory = new AddNodeMenuFactory();

    public CamelFeatureProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IAddFeature getAddFeature(IAddContext context) {
        if (context.getNewObject() instanceof EReference) {
            return new AddFlowFeature((IFeatureProvider)this);
        }
        if (context.getNewObject() instanceof AbstractNode) {
            return new AddNodeFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        RiderDesignEditor rider;
        ICreateFeature[] features = ProviderHelper.getCreateFeatures((IFeatureProvider)this);
        AbstractNode selectedNode = null;
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        IDiagramEditor diagramEditor = dtp.getDiagramEditor();
        if (diagramEditor instanceof RiderDesignEditor && (selectedNode = (rider = (RiderDesignEditor)diagramEditor).getSelectedNode()) == null) {
            selectedNode = rider.getSelectedRoute();
        }
        if (selectedNode != null) {
            ArrayList<ICreateFeature> featureList = new ArrayList<ICreateFeature>();
            featureList.addAll(Arrays.asList(features));
            Set<Endpoint> endpoints = AbstractNodes.getAllEndpoints(selectedNode);
            SortedMap<String, String> beans = AbstractNodes.getAllBeans(selectedNode);
            this.addEndpointInstances(featureList, endpoints);
            this.addBeanInstances(featureList, beans);
            return featureList.toArray(new ICreateFeature[featureList.size()]);
        }
        return features;
    }

    private void addBeanInstances(List<ICreateFeature> featureList, Map<String, String> beans) {
        Set<Map.Entry<String, String>> entrySet = beans.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            String aClass = entry.getValue();
            if (Strings.isBlank((String)name) && Strings.isBlank((String)aClass)) continue;
            Bean bean = new Bean();
            bean.setName(name);
            bean.setRef(name);
            bean.setBeanType(aClass);
            String title = bean.getDisplayText();
            String description = "bean '" + name + "' of type " + aClass;
            featureList.add((ICreateFeature)new CreateBeanFigureFeature((IFeatureProvider)this, title, description, bean));
        }
    }

    private void addEndpointInstances(List<ICreateFeature> featureList, Set<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            String id = endpoint.getId();
            String url = endpoint.getUri();
            if (Strings.isBlank((String)id) && Strings.isBlank((String)url)) continue;
            String description = endpoint.getDescription();
            String title = endpoint.getDisplayText();
            featureList.add((ICreateFeature)new CreateEndpointFigureFeature((IFeatureProvider)this, title, description, endpoint));
        }
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        Object bo;
        PictogramElement pictogramElement = context.getPictogramElement();
        if (pictogramElement instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pictogramElement)) instanceof AbstractNode) {
            return new UpdateNodeFeature((IFeatureProvider)this);
        }
        return super.getUpdateFeature(context);
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        Shape shape = context.getShape();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof AbstractNode) {
            return new MoveNodeFeature((IFeatureProvider)this);
        }
        return super.getMoveShapeFeature(context);
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return new DeleteNodeFeature((IFeatureProvider)this);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        return new RemoveNodeFeature((IFeatureProvider)this);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        Shape shape = context.getShape();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof AbstractNode) {
            return new ResizeNodeFeature((IFeatureProvider)this);
        }
        return super.getResizeShapeFeature(context);
    }

    public ILayoutFeature getLayoutFeature(ILayoutContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pictogramElement);
        if (bo instanceof AbstractNode) {
            return new LayoutNodeFeature((IFeatureProvider)this);
        }
        return super.getLayoutFeature(context);
    }

    public ICustomFeature[] getCustomFeatures(ICustomContext context) {
        return new ICustomFeature[]{new LayoutDiagramFeature((IFeatureProvider)this)};
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        return new ICreateConnectionFeature[]{new CreateFlowFeature((IFeatureProvider)this)};
    }

    public IFeature[] getDragAndDropFeatures(IPictogramElementContext context) {
        return this.getCreateConnectionFeatures();
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        return super.getDirectEditingFeature(context);
    }

    public ICopyFeature getCopyFeature(ICopyContext context) {
        return new CopyNodeFeature((IFeatureProvider)this);
    }

    public IPasteFeature getPasteFeature(IPasteContext context) {
        return new PasteNodeFeature((IFeatureProvider)this);
    }
}

