/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.provider;

import com.fusesource.rider.editor.Activator;
import com.fusesource.rider.editor.provider.generated.ProviderHelper;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.generated.Route;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;

public class ImageProvider
extends AbstractImageProvider {
    private static final String ROOT_FOLDER_FOR_IMG = "icons/";
    protected static final String PREFIX = "com.fusesource.demo.icons.";
    protected static final String POSTFIX_SMALL = "_small";
    protected static final String POSTFIX_LARGE = "_large";
    public static final String IMG_FLOW = "com.fusesource.demo.icons.flow";
    public static final String IMG_OUTLINE_TREE = "com.fusesource.demo.icons.outline.tree";
    public static final String IMG_OUTLINE_THUMBNAIL = "com.fusesource.demo.icons.outline.thumbnail";

    protected void addAvailableImages() {
        this.addImage(IMG_FLOW, "icons/flow16.png");
        this.addToImageRegistry(IMG_FLOW, "icons/flow16.png");
        this.addImage(IMG_OUTLINE_THUMBNAIL, "icons/thumbnail.gif");
        this.addToImageRegistry(IMG_OUTLINE_THUMBNAIL, "icons/thumbnail.gif");
        this.addImage(IMG_OUTLINE_TREE, "icons/tree.gif");
        this.addToImageRegistry(IMG_OUTLINE_TREE, "icons/tree.gif");
        ProviderHelper.addFigureIcons(this);
        this.addIconsForClass((AbstractNode)new Route(), "route16.png", "route.png");
    }

    public void addIconsForClass(AbstractNode node, String fileNameSmall, String fileNameLarge) {
        this.addImage(String.format("%s%s%s", PREFIX, node.getIconName(), POSTFIX_SMALL), ROOT_FOLDER_FOR_IMG + fileNameSmall);
        this.addImage(String.format("%s%s%s", PREFIX, node.getIconName(), POSTFIX_LARGE), ROOT_FOLDER_FOR_IMG + fileNameLarge);
        this.addToImageRegistry(String.format("%s%s%s", PREFIX, node.getIconName(), POSTFIX_SMALL), ROOT_FOLDER_FOR_IMG + fileNameSmall);
        this.addToImageRegistry(String.format("%s%s%s", PREFIX, node.getIconName(), POSTFIX_LARGE), ROOT_FOLDER_FOR_IMG + fileNameLarge);
    }

    private void addImage(String key, String value) {
        if (this.getImageFilePath(key) == null) {
            this.addImageFilePath(key, value);
        }
    }

    private void addToImageRegistry(String key, String path) {
        Activator.getDefault().getImageRegistry().put(key, Activator.imageDescriptorFromPlugin((String)"com.fusesource.rider.plugin.editor", (String)path));
    }

    public void addIconsForClass(AbstractNode node) {
        this.addIconsForClass(node, node.getSmallIconName(), node.getIconName());
    }

    public static String getKeyForSmallIcon(String iconName) {
        return String.format("%s%s%s", PREFIX, iconName, POSTFIX_SMALL);
    }

    public static String getKeyForLargeIcon(String iconName) {
        return String.format("%s%s%s", PREFIX, iconName, POSTFIX_LARGE);
    }
}

