/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.provider;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.editor.Messages;
import com.fusesource.rider.editor.features.custom.AddRouteFeature;
import com.fusesource.rider.editor.provider.PaletteCategoryItemProvider;
import com.fusesource.rider.editor.provider.generated.AddNodeMenuFactory;
import com.fusesource.rider.editor.validation.ValidationFactory;
import com.fusesource.rider.editor.validation.ValidationResult;
import com.fusesource.rider.model.AbstractNode;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ObjectCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;

public class ToolBehaviourProvider
extends DefaultToolBehaviorProvider {
    public ToolBehaviourProvider(IDiagramTypeProvider dtp) {
        super(dtp);
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        ICreateConnectionFeature[] features;
        IFeatureProvider featureProvider = this.getFeatureProvider();
        IContextButtonPadData data = super.getContextButtonPad(context);
        PictogramElement pe = context.getPictogramElement();
        this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE);
        CreateConnectionContext ccc = new CreateConnectionContext();
        ccc.setSourcePictogramElement(pe);
        Anchor anchor = null;
        if (pe instanceof Anchor) {
            anchor = (Anchor)pe;
        } else if (pe instanceof AnchorContainer) {
            anchor = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
        }
        ccc.setSourceAnchor(anchor);
        ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
        button.setText("Create connection");
        button.setIconId("com.fusesource.demo.icons.flow");
        ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = featureProvider.getCreateConnectionFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
            if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                button.addDragAndDropFeature((IFeature)feature);
            }
            ++n2;
        }
        if (button.getDragAndDropFeatures().size() > 0) {
            data.getDomainSpecificContextButtons().add(button);
        }
        return data;
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        LinkedList<ContextMenuEntry> entries = new LinkedList<ContextMenuEntry>();
        IFeatureProvider fp = this.getFeatureProvider();
        ICustomFeature[] customFeatures = fp.getCustomFeatures(context);
        int i = 0;
        while (i < customFeatures.length) {
            ICustomFeature customFeature = customFeatures[i];
            if (customFeature.isAvailable((IContext)context)) {
                ContextMenuEntry menuEntry = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                entries.add(menuEntry);
            }
            ++i;
        }
        ContextMenuEntry addNodesMenu = new ContextMenuEntry(null, null);
        addNodesMenu.setText("Add");
        addNodesMenu.setDescription("Add and connect new nodes");
        addNodesMenu.setSubmenu(true);
        AddNodeMenuFactory f = new AddNodeMenuFactory();
        f.setupMenuStructure(addNodesMenu, context, fp);
        entries.add(addNodesMenu);
        addNodesMenu.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new AddRouteFeature(fp), (IContext)context));
        return entries.toArray(new IContextMenuEntry[entries.size()]);
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<PaletteCompartmentEntry> ret = new ArrayList<PaletteCompartmentEntry>();
        PaletteCompartmentEntry compartmentEntryEndpoints = new PaletteCompartmentEntry(Messages.endpointsDrawerTitle, null);
        ret.add(compartmentEntryEndpoints);
        PaletteCompartmentEntry compartmentEntryRouting = new PaletteCompartmentEntry(Messages.routingDrawerTitle, null);
        ret.add(compartmentEntryRouting);
        PaletteCompartmentEntry compartmentEntryControlFlow = new PaletteCompartmentEntry(Messages.controlFlowDrawerTitle, null);
        ret.add(compartmentEntryControlFlow);
        PaletteCompartmentEntry compartmentEntryTransformation = new PaletteCompartmentEntry(Messages.transformationDrawerTitle, null);
        ret.add(compartmentEntryTransformation);
        PaletteCompartmentEntry compartmentEntryMisc = new PaletteCompartmentEntry(Messages.miscellaneousDrawerTitle, null);
        ret.add(compartmentEntryMisc);
        IPaletteCompartmentEntry[] superCompartments = super.getPalette();
        int i = 1;
        while (i < superCompartments.length) {
            IPaletteCompartmentEntry entry = superCompartments[i];
            for (IToolEntry toolEntry : entry.getToolEntries()) {
                ObjectCreationToolEntry octe;
                if (!(toolEntry instanceof ObjectCreationToolEntry) || !((octe = (ObjectCreationToolEntry)toolEntry).getCreateFeature() instanceof PaletteCategoryItemProvider)) continue;
                PaletteCategoryItemProvider pcit = (PaletteCategoryItemProvider)octe.getCreateFeature();
                switch (pcit.getCategoryType()) {
                    case ENDPOINTS: {
                        compartmentEntryEndpoints.addToolEntry(toolEntry);
                        break;
                    }
                    case ROUTING: {
                        compartmentEntryRouting.addToolEntry(toolEntry);
                        break;
                    }
                    case CONTROL_FLOW: {
                        compartmentEntryControlFlow.addToolEntry(toolEntry);
                        break;
                    }
                    case TRANSFORMATION: {
                        compartmentEntryTransformation.addToolEntry(toolEntry);
                        break;
                    }
                    case MISCELLANEOUS: {
                        compartmentEntryMisc.addToolEntry(toolEntry);
                        break;
                    }
                }
            }
            ++i;
        }
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        LinkedList<ImageDecorator> decorators = new LinkedList<ImageDecorator>();
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode) {
            ImageDecorator imageRenderingDecorator;
            AbstractNode node = (AbstractNode)bo;
            ValidationResult res = ValidationFactory.getInstance().validate(node);
            if (res.getInformationCount() > 0) {
                for (String message : res.getInformations()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.information.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            if (res.getWarningCount() > 0) {
                for (String message : res.getWarnings()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            if (res.getErrorCount() > 0) {
                for (String message : res.getErrors()) {
                    imageRenderingDecorator = new ImageDecorator("org.eclipse.graphiti.eclipse.error.tsk");
                    imageRenderingDecorator.setMessage(message);
                    decorators.add(imageRenderingDecorator);
                }
            }
            return decorators.toArray(new IDecorator[decorators.size()]);
        }
        return super.getDecorators(pe);
    }

    public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }
        return super.getClickArea(pe);
    }

    public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
        GraphicsAlgorithm invisible;
        EList graphicsAlgorithmChildren;
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode && !(graphicsAlgorithmChildren = (invisible = pe.getGraphicsAlgorithm()).getGraphicsAlgorithmChildren()).isEmpty()) {
            return (GraphicsAlgorithm)graphicsAlgorithmChildren.get(0);
        }
        return super.getSelectionBorder(pe);
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        String name;
        PictogramElement pe = ga.getPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof AbstractNode && (name = ((AbstractNode)bo).getDisplayToolTip()) != null && !name.isEmpty()) {
            return name;
        }
        return super.getToolTip(ga);
    }

    public boolean equalsBusinessObjects(Object o1, Object o2) {
        if (o1 instanceof AbstractNode || o2 instanceof AbstractNode) {
            return Objects.equal((Object)o1, (Object)o2);
        }
        return super.equalsBusinessObjects(o1, o2);
    }

    public boolean isMultiSelectionEnabled() {
        return true;
    }
}

