/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.utils;

import com.fusesource.rider.editor.editor.RiderDesignEditor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class CamelContextSelectionSynchronizer
extends SelectionSynchronizer {
    private RiderDesignEditor editor;

    public CamelContextSelectionSynchronizer(RiderDesignEditor editor) {
        this.editor = editor;
    }

    protected EditPart convert(EditPartViewer viewer, EditPart part) {
        Object o = part.getModel();
        if (o instanceof RouteSupport) {
            RouteSupport newRoute = (RouteSupport)o;
            RouteSupport oldRoute = this.editor.getSelectedRoute();
            if (!oldRoute.equals((Object)newRoute)) {
                this.editor.switchRoute(newRoute);
            }
            return viewer.getRootEditPart();
        }
        if (o instanceof RouteContainer) {
            return viewer.getRootEditPart();
        }
        if (o instanceof AbstractNode) {
            AbstractNode node;
            PictogramElement[] pes = this.editor.getFeatureProvider().getAllPictogramElementsForBusinessObject(o);
            if (pes.length > 0) {
                RouteSupport newRoute;
                node = (AbstractNode)o;
                RouteSupport oldRoute = this.editor.getSelectedRoute();
                if (!oldRoute.equals((Object)(newRoute = (RouteSupport)node.getParent()))) {
                    this.editor.switchRoute(newRoute);
                    this.editor.autoLayoutRoute();
                }
            }
            if (pes.length == 0) {
                node = (AbstractNode)o;
                this.editor.switchRoute((RouteSupport)node.getParent());
                this.editor.refreshContent();
                for (Map.Entry e : viewer.getEditPartRegistry().entrySet()) {
                    ContainerShape cs;
                    Object key = e.getKey();
                    EditPart value = (EditPart)e.getValue();
                    if (!(key instanceof ContainerShape) || (cs = (ContainerShape)key).getLink() == null || cs.getLink().getBusinessObjects() == null || cs.getLink().getBusinessObjects().size() <= 0 || cs.getLink().getBusinessObjects().get(0) == null || !((EObject)cs.getLink().getBusinessObjects().get(0)).equals(o)) continue;
                    return value;
                }
                return viewer.getRootEditPart();
            }
            return this.editor.getEditPartForPictogramElement(pes[0]);
        }
        if (o instanceof Diagram) {
            RouteSupport route = this.editor.getSelectedRoute();
            return this.getEditPart(viewer, (AbstractNode)route);
        }
        if (o instanceof ContainerShape) {
            AbstractNode node = (AbstractNode)((ContainerShape)o).getLink().getBusinessObjects().get(0);
            return this.getEditPart(viewer, node);
        }
        return super.convert(viewer, part);
    }

    private EditPart getEditPart(EditPartViewer viewer, AbstractNode node) {
        for (Map.Entry e : viewer.getEditPartRegistry().entrySet()) {
            AbstractNode n;
            Object key = e.getKey();
            EditPart value = (EditPart)e.getValue();
            if (!(key instanceof AbstractNode) || !(n = (AbstractNode)key).equals((Object)node)) continue;
            return value;
        }
        return viewer.getRootEditPart();
    }
}

