/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.utils;

import com.fusesource.rider.preferences.PreferenceManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.styles.AdaptedGradientColoredAreas;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;
import org.eclipse.swt.widgets.Display;

public class StyleUtil {
    private static final IColorConstant E_CLASS_TEXT_FOREGROUND = StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramTextColorPreference"));
    private static final IColorConstant E_CLASS_FOREGROUND = StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramFigureForegroundColorPreference"));
    private static final IColorConstant E_CLASS_BACKGROUND = StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramFigureBackgroundColorPreference"));
    private static final IColorConstant E_CLASS_SHADOW_FOREGROUND = StyleUtil.getColorConstant("128,128,128");
    private static final IColorConstant E_CLASS_SHADOW_BACKGROUND = StyleUtil.getColorConstant("128,128,128");
    private static final AdaptedGradientColoredAreas E_CLASS_GRADIENT = PredefinedColoredAreas.getBlueWhiteGlossAdaptions();
    private static final String DEFAULT_FONT = Display.getDefault().getSystemFont().getFontData()[0].getName();
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final boolean USE_GRADIENT_BACKGROUND = false;

    public static Style getStyleForEClass(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "E-CLASS");
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)diagram, "E-CLASS");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_FOREGROUND));
            style.setBackground(gaService.manageColor(diagram, E_CLASS_BACKGROUND));
            style.setFilled(Boolean.valueOf(true));
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForCamelClass(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "FUSE-CAMEL-NODE");
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)diagram, "FUSE-CAMEL-NODE");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_FOREGROUND));
            style.setBackground(gaService.manageColor(diagram, E_CLASS_BACKGROUND));
            style.setFilled(Boolean.valueOf(true));
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getShadowStyleForCamelClass(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "FUSE-CAMEL-NODE-SHADOW");
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)diagram, "FUSE-CAMEL-NODE-SHADOW");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_SHADOW_FOREGROUND));
            style.setBackground(gaService.manageColor(diagram, E_CLASS_SHADOW_BACKGROUND));
            style.setFilled(Boolean.valueOf(true));
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForCamelText(Diagram diagram) {
        IGaService gaService = Graphiti.getGaService();
        Style parentStyle = StyleUtil.getStyleForEClass(diagram);
        Style style = null;
        style = parentStyle == null ? gaService.createStyle((StyleContainer)diagram, "FUSE-CAMEL-NODE-TEXT") : StyleUtil.findStyle((StyleContainer)parentStyle, "FUSE-CAMEL-NODE-TEXT");
        if (style == null) {
            style = gaService.createStyle((StyleContainer)StyleUtil.getStyleForEClass(diagram), "FUSE-CAMEL-NODE-TEXT");
            style.setForeground(gaService.manageColor(diagram, E_CLASS_TEXT_FOREGROUND));
        }
        style.setFont(gaService.manageFont(diagram, DEFAULT_FONT, 10, false, true));
        return style;
    }

    public static Style getStyleForPolygon(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "FUSE-CAMEL-POLYGON-ARROW");
        IGaService gaService = Graphiti.getGaService();
        if (style == null) {
            style = gaService.createStyle((StyleContainer)diagram, "FUSE-CAMEL-POLYGON-ARROW");
            style.setForeground(gaService.manageColor(diagram, StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramConnectionColorPreference"))));
            style.setBackground(gaService.manageColor(diagram, StyleUtil.getColorConstant(PreferenceManager.getInstance().loadPreferenceAsString("diagramConnectionColorPreference"))));
            style.setLineWidth(Integer.valueOf(1));
        }
        return style;
    }

    private static Style findStyle(StyleContainer styleContainer, String id) {
        EList styles = styleContainer.getStyles();
        if (styles != null) {
            for (Style style : styles) {
                if (!id.equals(style.getId())) continue;
                return style;
            }
        }
        return null;
    }

    public static IColorConstant getColorConstant(String rgb) {
        ColorConstant cc = null;
        String[] parts = rgb.split(",");
        if (parts.length != 3) {
            return null;
        }
        String hex = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String h;
            String part = stringArray[n2];
            if (Character.isDigit(part.charAt(0))) {
                int i = Integer.parseInt(part.trim());
                h = Integer.toHexString(i);
            } else {
                h = part;
            }
            if (h.length() < 2) {
                hex = String.valueOf(hex) + "0";
            }
            hex = String.valueOf(hex) + h;
            ++n2;
        }
        cc = new ColorConstant(hex);
        return cc;
    }
}

