/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.validation;

import com.fusesource.rider.editor.validation.AbstractNodeValidator;
import com.fusesource.rider.editor.validation.ValidationResult;
import com.fusesource.rider.editor.validation.impl.EndpointValidator;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Endpoint;
import java.util.HashMap;
import java.util.Map;

public final class ValidationFactory {
    private static Map<Class<? extends AbstractNode>, AbstractNodeValidator> registeredValidators = new HashMap<Class<? extends AbstractNode>, AbstractNodeValidator>();
    private static ValidationFactory instance;

    static {
        registeredValidators.put(Endpoint.class, new EndpointValidator());
    }

    private ValidationFactory() {
    }

    public static synchronized ValidationFactory getInstance() {
        if (instance == null) {
            instance = new ValidationFactory();
        }
        return instance;
    }

    public ValidationResult validate(AbstractNode node) {
        ValidationResult result = null;
        AbstractNodeValidator validator = registeredValidators.get(node.getClass());
        result = validator != null ? validator.validate(node) : new ValidationResult();
        return result;
    }
}

