/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.views;

import com.fusesource.ide.graph.GraphFilter;
import com.fusesource.ide.graph.GraphLabelProviderSupport;
import com.fusesource.ide.graph.GraphViewSupport;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.editor.AbstractNodes;
import com.fusesource.rider.editor.editor.RiderEditor;
import com.fusesource.rider.editor.views.DiagramGraphLabelProvider;
import com.fusesource.rider.editor.views.NodeGraphContentProvider;
import com.fusesource.rider.editor.views.RouteGraphContentProvider;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import com.fusesource.rider.model.generated.Route;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.fusesource.fon.util.messages.Exchanges;
import org.fusesource.fon.util.messages.HasNodeStatisticsContainer;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.NodeStatisticsContainer;

public class DiagramView
extends GraphViewSupport {
    public static final String ID = "com.fusesource.rider.editor.views.RouteView";
    private Node selectedNode;
    AbstractNode node;
    private NodeStatisticsContainer nodeStatisticsContainer;
    private IWorkbenchPart selectionPart;

    protected GraphLabelProviderSupport createGraphLabelProvider() {
        return new DiagramGraphLabelProvider(this);
    }

    protected NodeGraphContentProvider createGraphContentProvider() {
        return new NodeGraphContentProvider();
    }

    public NodeStatisticsContainer getNodeStatisticsContainer() {
        return this.nodeStatisticsContainer;
    }

    protected GraphFilter createGraphFilter() {
        return new GraphFilter(this){

            protected boolean canFilterNode(Object element) {
                return !Objects.equal((Object)element, (Object)DiagramView.this.node) && !Objects.equal((Object)element, (Object)DiagramView.this.selectedNode);
            }
        };
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (site != null) {
            site.getWorkbenchWindow().getSelectionService().addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    String toNode;
                    IMessage in;
                    AbstractNode node;
                    if (!DiagramView.this.isRelevantSelectionSource(part, selection)) {
                        return;
                    }
                    Object firstSelection = Selections.getFirstSelection((ISelection)selection);
                    if (selection.isEmpty()) {
                        return;
                    }
                    if (part.getClass().getName().equals("com.fusesource.ide.fabric.views.MessagesView")) {
                        String toNode2;
                        IMessage in2;
                        if (firstSelection != null && (in2 = Exchanges.asMessage((Object)firstSelection)) != null && (toNode2 = in2.getToNode()) != null) {
                            DiagramView.this.selectNodeId(toNode2, in2.getEndpointUri());
                        }
                        return;
                    }
                    if (firstSelection != null) {
                        DiagramView.this.updateselection(firstSelection);
                    }
                    if ((node = AbstractNodes.getSelectedNode(selection)) != null && !(part instanceof RiderEditor)) {
                        DiagramView.this.updateGraph(node, part);
                    } else if (firstSelection instanceof Node) {
                        DiagramView.this.updateGraph((Node)firstSelection, part);
                    } else if (firstSelection instanceof IConnectionWrapper) {
                        DiagramView.this.viewer.setContentProvider((IContentProvider)new NodeGraphContentProvider());
                        DiagramView.this.setSelectedObjectOnly(firstSelection);
                    } else if (firstSelection != null && (in = Exchanges.asMessage((Object)firstSelection)) != null && (toNode = in.getToNode()) != null) {
                        DiagramView.this.selectNodeId(toNode, in.getEndpointUri());
                    }
                }
            });
        }
    }

    private boolean isRelevantSelectionSource(IWorkbenchPart part, ISelection selection) {
        boolean process = false;
        if (part.getClass().getName().equals("com.fusesource.ide.jmx.ui.internal.views.navigator.Navigator") || part.getClass().getName().equals("com.fusesource.ide.fabric.navigator.FabricNavigator") || part.getClass().getName().equals("com.fusesource.ide.fabric.views.MessagesView") || part.getClass().getName().equals("org.eclipse.ui.views.properties.PropertySheet")) {
            process = true;
        }
        return process;
    }

    protected void updateselection(Object firstSelection) {
        if (firstSelection != null) {
            this.nodeStatisticsContainer = null;
            if (firstSelection instanceof HasNodeStatisticsContainer) {
                HasNodeStatisticsContainer hasNodeStatisticsContainer = (HasNodeStatisticsContainer)firstSelection;
                this.nodeStatisticsContainer = hasNodeStatisticsContainer.getNodeStatisticsContainer();
            } else if (firstSelection instanceof NodeStatisticsContainer) {
                this.nodeStatisticsContainer = (NodeStatisticsContainer)firstSelection;
            }
        } else {
            this.selectedNode = null;
            this.node = null;
            this.nodeStatisticsContainer = null;
            this.clearDiagramGraph();
        }
    }

    protected void clearDiagramGraph() {
        this.setSelectedObjectOnly(null);
        this.viewer.refresh();
    }

    public void updateGraph(AbstractNode node, IWorkbenchPart part) {
        this.node = node;
        this.selectionPart = part;
        RouteGraphContentProvider contentProvider = new RouteGraphContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.setInputAndSelection(node, node);
    }

    public void updateGraph(Node node, IWorkbenchPart part) {
        this.selectedNode = node;
        this.selectionPart = part;
        this.viewer.setContentProvider((IContentProvider)new NodeGraphContentProvider());
        this.setSelectedObjectOnly(node);
    }

    protected boolean selectNodeId(String toNode, String endpointUri) {
        AbstractNode newSelection;
        RouteContainer parent;
        if (this.node != null && (parent = this.getParentContainer()) != null && (newSelection = parent.getNode(toNode)) != null) {
            if (newSelection instanceof Route) {
                if (endpointUri != null) {
                    return this.selectEndpointUri(endpointUri);
                }
                Route route = (Route)newSelection;
                if (!route.getSourceNodes().isEmpty()) {
                    newSelection = (AbstractNode)route.getSourceNodes().get(0);
                }
            }
            if (newSelection != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSelection));
                return true;
            }
        }
        return false;
    }

    protected boolean selectEndpointUri(String uri) {
        RouteContainer parent;
        if (this.node != null && (parent = this.getParentContainer()) instanceof RouteSupport) {
            RouteSupport route = (RouteSupport)parent;
            Endpoint newSelection = route.findEndpoint(uri);
            if (newSelection == null) {
                List children = parent.getChildren();
                for (AbstractNode child : children) {
                    if (child instanceof RouteSupport && (newSelection = (route = (RouteSupport)child).findEndpoint(uri)) != null) break;
                }
            }
            if (newSelection != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)newSelection));
                return true;
            }
        }
        return false;
    }

    protected RouteContainer getParentContainer() {
        RouteContainer parent = this.node.getParent();
        if (parent == null && this.node instanceof RouteContainer) {
            parent = (RouteContainer)this.node;
        }
        return parent;
    }

    protected void doubleClickSelection(ISelection selection) {
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        IViewSite viewSite = this.getViewSite();
        if (obj instanceof Node) {
            IWorkbenchPartSite activeSite;
            IWorkbenchPart activePart;
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            ISelectionProvider selectionProvider = Selections.getSelectionProvider((IViewSite)viewSite);
            IWorkbenchPartSite site = this.getSite();
            if (selectionProvider == null && site != null && (selectionProvider = site.getSelectionProvider()) == null && (workbenchWindow = site.getWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) != null && (activeSite = activePart.getSite()) != null) {
                selectionProvider = activeSite.getSelectionProvider();
            }
            if (selectionProvider == null) {
                selectionProvider = Selections.getSelectionProvider((IWorkbenchPart)this.selectionPart);
            }
            if (selectionProvider != null) {
                selectionProvider.setSelection(selection);
            }
        }
    }
}

