/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.editor.views;

import com.fusesource.rider.commons.tree.ConnectedNode;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.GraphableNodeConnected;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;

public class NodeGraphContentProvider
implements IStructuredContentProvider,
IGraphEntityContentProvider {
    private static final Object[] EMPTY = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object input) {
        if (input instanceof AbstractNode) {
            RouteContainer parent;
            AbstractNode node = (AbstractNode)input;
            HashSet<AbstractNode> set = new HashSet<AbstractNode>();
            if (node instanceof RouteContainer) {
                parent = (RouteContainer)node;
            } else {
                parent = node.getParent();
                set.add(node);
            }
            if (parent == null) {
                set.addAll(node.getOutputs());
            } else {
                set.addAll(parent.getDescendents());
            }
            return set.toArray();
        }
        ArrayList<Object> answer = new ArrayList<Object>();
        if (input instanceof GraphableNode) {
            GraphableNode node = (GraphableNode)input;
            answer.addAll(node.getChildrenGraph());
        } else if (input != null) {
            answer.add(input);
            if (input instanceof Node) {
                Node aNode = (Node)input;
                answer.addAll(aNode.getChildrenList());
            }
        } else {
            return null;
        }
        return answer.toArray();
    }

    public Object[] getConnectedTo(Object entity) {
        if (entity instanceof GraphableNodeConnected) {
            GraphableNodeConnected gn = (GraphableNodeConnected)entity;
            return gn.getGraphConnectedTo().toArray();
        }
        if (entity instanceof RouteSupport) {
            RouteSupport route = (RouteSupport)entity;
            return route.getRootNodes().toArray();
        }
        if (entity instanceof AbstractNode) {
            AbstractNode node = (AbstractNode)entity;
            node.getOutputs().toArray();
        } else {
            if (entity instanceof ConnectedNode) {
                ConnectedNode node = (ConnectedNode)entity;
                return node.getConnectedTo().toArray();
            }
            if (entity instanceof Node) {
                Node aNode = (Node)entity;
                return aNode.getChildren();
            }
        }
        return EMPTY;
    }
}

