/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal.handler;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IPreparationContext;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabCellImpl;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabImpl;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.BaseCrosstabEventHandler;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabScriptHandler;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;

public class CrosstabPreparationHandler
extends BaseCrosstabEventHandler
implements ICrosstabConstants {
    private static final Logger logger = Logger.getLogger(CrosstabPreparationHandler.class.getName());
    private static final String AUTO_EMPTY_VALUE_EXPR_PREFIX = "/*AUTO_EXPR_EMPTY_VALUE*/";
    private CrosstabScriptHandler handler;
    private CrosstabReportItemHandle crosstab;
    private IPreparationContext context;

    public CrosstabPreparationHandler(CrosstabReportItemHandle crosstab, IPreparationContext context) throws BirtException {
        ExtendedItemHandle modelHandle = (ExtendedItemHandle)crosstab.getModelHandle();
        String javaClass = modelHandle.getEventHandlerClass();
        String script = modelHandle.getOnPrepare();
        this.crosstab = crosstab;
        this.context = context;
        if (!(javaClass != null && javaClass.trim().length() != 0 || script != null && script.trim().length() != 0)) {
            return;
        }
        this.handler = this.createScriptHandler((DesignElementHandle)modelHandle, "onPrepare", script, context.getApplicationClassLoader());
    }

    public void handle() throws BirtException {
        if (this.handler != null) {
            CrosstabImpl crosstabItem = new CrosstabImpl(this.crosstab);
            this.handler.callFunction("onPrepareCrosstab", crosstabItem, this.context);
        }
        this.handleChildren();
    }

    private void handleChildren() throws BirtException {
        LevelViewHandle lv;
        int j;
        DimensionViewHandle dv;
        int i;
        String emptyValue = this.crosstab.getEmptyCellValue();
        this.handleCell(this.crosstab.getHeader(), null);
        if (this.crosstab.getDimensionCount(1) > 0) {
            i = 0;
            while (i < this.crosstab.getDimensionCount(1)) {
                dv = this.crosstab.getDimension(1, i);
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    this.handleCell(lv.getCell(), null);
                    this.handleCell(lv.getAggregationHeader(), null);
                    ++j;
                }
                ++i;
            }
        }
        this.handleCell(this.crosstab.getGrandTotal(1), null);
        if (this.crosstab.getDimensionCount(0) > 0) {
            i = 0;
            while (i < this.crosstab.getDimensionCount(0)) {
                dv = this.crosstab.getDimension(0, i);
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    this.handleCell(lv.getCell(), null);
                    this.handleCell(lv.getAggregationHeader(), null);
                    ++j;
                }
                ++i;
            }
        }
        this.handleCell(this.crosstab.getGrandTotal(0), null);
        i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle mv = this.crosstab.getMeasure(i);
            j = 0;
            while (j < mv.getHeaderCount()) {
                this.handleCell(mv.getHeader(j), null);
                ++j;
            }
            this.handleCell(mv.getCell(), emptyValue);
            j = 0;
            while (j < mv.getAggregationCount()) {
                this.handleCell(mv.getAggregationCell(j), emptyValue);
                ++j;
            }
            ++i;
        }
    }

    private void handleCell(CrosstabCellHandle cell, String emptyVlaue) throws BirtException {
        if (cell == null) {
            return;
        }
        if (this.handler != null) {
            CrosstabCellImpl cellItem = new CrosstabCellImpl(cell);
            this.handler.callFunction("onPrepareCell", cellItem, this.context);
        }
        for (ReportElementHandle handle : cell.getContents()) {
            this.context.prepare((DesignElementHandle)handle);
            if (!(handle instanceof DataItemHandle)) continue;
            DataItemHandle dataHandle = (DataItemHandle)handle;
            PropertyHandle mapHandle = dataHandle.getPropertyHandle("mapRules");
            ArrayList rules = mapHandle.getListValue();
            if (rules != null) {
                ArrayList<MapRule> removeList = new ArrayList<MapRule>();
                for (MapRule rl : rules) {
                    if (rl.getTestExpression() == null || !rl.getTestExpression().startsWith(AUTO_EMPTY_VALUE_EXPR_PREFIX)) continue;
                    removeList.add(rl);
                }
                if (removeList.size() > 0) {
                    mapHandle.removeItems(removeList);
                }
            }
            if (emptyVlaue == null) continue;
            MapRule rule = StructureFactory.createMapRule();
            rule.setTestExpression(AUTO_EMPTY_VALUE_EXPR_PREFIX + ExpressionUtil.createJSDataExpression((String)dataHandle.getResultSetColumn()));
            rule.setOperator("is-null");
            rule.setDisplay(emptyVlaue);
            try {
                mapHandle.addItem((IStructure)rule);
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemQuery.error.register.empty.cell.value"), e);
            }
        }
    }
}

