/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.report.data.adapter.api.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabUtil
implements ICrosstabConstants {
    private CrosstabUtil() {
    }

    public static int getOppositeAxisType(int axisType) {
        switch (axisType) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    public static IReportItem getReportItem(DesignElementHandle element) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        try {
            return extendedItem.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            return null;
        }
    }

    public static IReportItem getReportItem(DesignElementHandle element, String extensionName) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name can not be null");
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        if (extensionName.equals(extendedItem.getExtensionName())) {
            try {
                return extendedItem.getReportItem();
            }
            catch (ExtendedElementException extendedElementException) {
                return null;
            }
        }
        return null;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, DimensionHandle dimension) {
        if (crosstab != null && crosstab.getModelHandle().getExtends() != null) {
            return false;
        }
        if (crosstab != null && dimension != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (dimension.getElement().isContentOf(currentCube.getElement())) {
                DimensionViewHandle dv;
                int i = 0;
                while (i < crosstab.getDimensionCount(0)) {
                    dv = crosstab.getDimension(0, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < crosstab.getDimensionCount(1)) {
                    dv = crosstab.getDimension(1, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, MeasureHandle measure) {
        if (crosstab != null && crosstab.getModelHandle().getExtends() != null) {
            return false;
        }
        if (crosstab != null && measure != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (measure.getElement().isContentOf(currentCube.getElement())) {
                int i = 0;
                while (i < crosstab.getMeasureCount()) {
                    MeasureViewHandle mv = crosstab.getMeasure(i);
                    if (mv.getCubeMeasure() == measure) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, MeasureGroupHandle obj) {
        return crosstab.getModelHandle().getExtends() == null;
    }

    public static boolean isAggregationAffectAllMeasures(CrosstabReportItemHandle crosstabItem, int axisType) {
        String measureDirection = crosstabItem.getMeasureDirection();
        return "horizontal".equals(measureDirection) && axisType == 0 || "vertical".equals(measureDirection) && axisType == 1;
    }

    public static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        return CrosstabModelUtil.getDefaultMeasureAggregationFunction(mv);
    }

    public static void addDataItem(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        CrosstabModelUtil.addDataItem(crosstab, cell, measureView, function, rowDimension, rowLevel, colDimension, colLevel, false);
    }

    public static List<IDimensionLevel> getReferencedLevels(LevelViewHandle level, String bindingExpr) {
        DesignElementHandle dimensionHandle;
        LevelHandle levelHandle = level.getCubeLevel();
        if (level.getCubeLevel() == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle hierarchyHandle = levelHandle.getContainer();
        DesignElementHandle designElementHandle = dimensionHandle = hierarchyHandle == null ? null : hierarchyHandle.getContainer();
        if (dimensionHandle == null) {
            return Collections.EMPTY_LIST;
        }
        String targetLevel = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)levelHandle.getName());
        CrosstabReportItemHandle crosstab = level.getCrosstab();
        try {
            List<IBinding> bindings = CrosstabUtil.getQueryBindings(crosstab);
            List<String> rowExpList = CrosstabUtil.getLevelExpressionList(crosstab, 0);
            List<String> colExpList = CrosstabUtil.getLevelExpressionList(crosstab, 1);
            return CubeQueryUtil.getReferencedLevels((String)targetLevel, (String)bindingExpr, bindings, rowExpList, colExpList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    private static List<IBinding> getQueryBindings(CrosstabReportItemHandle crosstabItem) throws BirtException {
        LevelViewHandle lv;
        int j;
        DimensionViewHandle dv;
        int i;
        ArrayList<String> rowLevelNameList = new ArrayList<String>();
        ArrayList<String> columnLevelNameList = new ArrayList<String>();
        if (crosstabItem.getDimensionCount(0) > 0) {
            i = 0;
            while (i < crosstabItem.getDimensionCount(0)) {
                dv = crosstabItem.getDimension(0, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
                }
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                    }
                    rowLevelNameList.add(lv.getCubeLevel().getFullName());
                    ++j;
                }
                ++i;
            }
        }
        if (crosstabItem.getDimensionCount(1) > 0) {
            i = 0;
            while (i < crosstabItem.getDimensionCount(1)) {
                dv = crosstabItem.getDimension(1, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.column", dv.getCubeDimensionName()));
                }
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.column", lv.getCubeLevelName()));
                    }
                    columnLevelNameList.add(lv.getCubeLevel().getFullName());
                    ++j;
                }
                ++i;
            }
        }
        ArrayList<IBinding> bindingList = new ArrayList<IBinding>();
        Iterator bindingItr = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
        ModuleHandle module = ((ExtendedItemHandle)crosstabItem.getModelHandle()).getModuleHandle();
        if (bindingItr != null) {
            HashMap<String, String> cache = new HashMap<String, String>();
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            try {
                IModelAdapter modelAdapter = session.getModelAdaptor();
                while (bindingItr.hasNext()) {
                    ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                    IBinding binding = modelAdapter.adaptBinding(column, IModelAdapter.ExpressionLocation.CUBE);
                    List aggrList = column.getAggregateOnList();
                    if (aggrList != null) {
                        for (String baseLevel : aggrList) {
                            CrosstabUtil.addHierachyAggregateOn(module, binding, baseLevel, rowLevelNameList, columnLevelNameList, cache);
                        }
                    }
                    bindingList.add(binding);
                }
            }
            finally {
                session.shutdown();
            }
        }
        return bindingList;
    }

    public static void addHierachyAggregateOn(ModuleHandle module, IBinding binding, String baseLevel, List<String> rowLevelList, List<String> columnLevelList, Map<String, String> cache) throws BirtException {
        if (binding == null || baseLevel == null || module == null) {
            return;
        }
        int sindex = rowLevelList.indexOf(baseLevel);
        if (sindex != -1) {
            int i = 0;
            while (i <= sindex) {
                String levelName = rowLevelList.get(i);
                String cachedExpression = cache.get(levelName);
                if (cachedExpression == null) {
                    cachedExpression = CrosstabUtil.createAggregateLevelExpression(levelName);
                    cache.put(levelName, cachedExpression);
                }
                if (cachedExpression != null) {
                    binding.addAggregateOn(cachedExpression);
                }
                ++i;
            }
            return;
        }
        sindex = columnLevelList.indexOf(baseLevel);
        if (sindex != -1) {
            int i = 0;
            while (i <= sindex) {
                String levelName = columnLevelList.get(i);
                String cachedExpression = cache.get(levelName);
                if (cachedExpression == null) {
                    cachedExpression = CrosstabUtil.createAggregateLevelExpression(levelName);
                    cache.put(levelName, cachedExpression);
                }
                if (cachedExpression != null) {
                    binding.addAggregateOn(cachedExpression);
                }
                ++i;
            }
            return;
        }
        String cachedExpression = cache.get(baseLevel);
        if (cachedExpression == null) {
            cachedExpression = CrosstabUtil.createAggregateLevelExpression(baseLevel);
            cache.put(baseLevel, cachedExpression);
        }
        if (cachedExpression != null) {
            binding.addAggregateOn(cachedExpression);
        }
    }

    private static String createAggregateLevelExpression(String levelFullName) {
        String[] names = CubeUtil.splitLevelName((String)levelFullName);
        return ExpressionUtil.createJSDimensionExpression((String)names[0], (String)names[1]);
    }

    private static List<String> getLevelExpressionList(CrosstabReportItemHandle crosstab, int axis) throws CrosstabException {
        ArrayList<String> expList = new ArrayList<String>();
        int count = crosstab.getDimensionCount(axis);
        int i = 0;
        while (i < count) {
            DimensionViewHandle dv = crosstab.getDimension(axis, i);
            if (dv.getCubeDimension() == null) {
                throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
            }
            int j = 0;
            while (j < dv.getLevelCount()) {
                LevelViewHandle lv = dv.getLevel(j);
                if (lv.getCubeLevel() == null) {
                    throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                }
                String expression = ExpressionUtil.createJSDimensionExpression((String)dv.getCubeDimension().getName(), (String)lv.getCubeLevel().getName());
                expList.add(expression);
                ++j;
            }
            ++i;
        }
        return expList;
    }

    public static DimensionViewHandle getDimensionViewHandle(CrosstabReportItemHandle crosstab, String dimensionShortName) {
        DimensionViewHandle dimension = null;
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] type = nArray;
        int i = 0;
        while (i < type.length) {
            int count = crosstab.getDimensionCount(type[i]);
            int j = 0;
            while (j < count) {
                DimensionViewHandle tmpDimension = crosstab.getDimension(type[i], j);
                if (tmpDimension != null && tmpDimension.getCubeDimension().getName().equals(dimensionShortName)) {
                    dimension = tmpDimension;
                    return dimension;
                }
                ++j;
            }
            ++i;
        }
        return dimension;
    }
}

