/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartSpinner;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class StockSeriesAttributeComposite
extends Composite
implements Listener {
    private LineAttributesComposite liacStock = null;
    protected ChartSpinner iscStick = null;
    protected StockSeries series = null;
    protected StockSeries defSeries = null;
    protected transient ChartWizardContext context;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public StockSeriesAttributeComposite(Composite parent, int style, ChartWizardContext context, Series series) {
        super(parent, style);
        if (!(series instanceof StockSeries)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "StockSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (StockSeries)series;
        this.defSeries = (StockSeries)ChartDefaultValueUtil.getDefaultSeries((Series)this.series);
        this.context = context;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatStockChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    protected void placeComponents() {
        this.setLayout((Layout)new GridLayout());
        Group grpLine = new Group((Composite)this, 0);
        grpLine.setText(Messages.getString("StockSeriesAttributeComposite.Lbl.Line"));
        GridLayout glLine = new GridLayout();
        glLine.numColumns = this.needStickLength() ? 4 : 1;
        grpLine.setLayout((Layout)glLine);
        grpLine.setLayoutData((Object)new GridData(768));
        this.initUIComponents(grpLine);
    }

    protected void initUIComponents(Group grpLine) {
        this.liacStock = new LineAttributesComposite((Composite)grpLine, 0, this.context, this.series.getLineAttributes(), true, true, false, true, true, this.defSeries.getLineAttributes());
        GridData gdLIACStock = new GridData(768);
        gdLIACStock.verticalSpan = 3;
        this.liacStock.setLayoutData(gdLIACStock);
        this.liacStock.addListener(this);
        if (this.needStickLength()) {
            Composite comp = new Composite((Composite)grpLine, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            comp.setLayoutData((Object)gd);
            GridLayout gl = new GridLayout();
            gl.numColumns = 3;
            gl.marginBottom = 0;
            gl.marginHeight = 0;
            gl.marginLeft = 0;
            gl.marginRight = 0;
            gl.marginTop = 0;
            gl.marginWidth = 0;
            comp.setLayout((Layout)gl);
            new Label(comp, 0).setText(Messages.getString("StockSeriesAttributeComposite.Lbl.StickLength"));
            this.iscStick = this.context.getUIFactory().createChartSpinner(comp, 2048, (EObject)this.series, "stickLength", true);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.iscStick.setLayoutData((Object)gd);
            this.iscStick.getWidget().setMinimum(0);
            this.iscStick.getWidget().setMaximum(Integer.MAX_VALUE);
            this.iscStick.getWidget().setSelection(this.series.getStickLength());
        }
    }

    protected boolean needStickLength() {
        return this.series.isShowAsBarStick();
    }

    public Point getPreferredSize() {
        return new Point(400, 200);
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (event.widget.equals((Object)this.liacStock)) {
            if (event.type == 4) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getLineAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
            } else if (event.type == 1) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getLineAttributes(), (String)"style", (Object)event.data, (boolean)isUnset);
            } else if (event.type == 2) {
                ChartElementUtil.setEObjectAttribute((EObject)this.series.getLineAttributes(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
            } else if (event.type == 3) {
                this.series.getLineAttributes().setColor((ColorDefinition)event.data);
            }
        }
    }
}

