/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Stretch;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.util.ChartDefaultValueUtil;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartInsets;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class TitleBlockSheet
extends AbstractPopupSheet
implements SelectionListener,
Listener {
    private transient Composite cmpContent;
    private transient Group grpGeneral;
    private transient ChartCombo cmbAnchor;
    private transient ChartCombo cmbStretch;
    private transient Group grpOutline;
    private transient LineAttributesComposite liacOutline;
    private transient FillChooserComposite fccBackground;
    private transient AbstractChartInsets ic;

    public TitleBlockSheet(String title, ChartWizardContext context) {
        super(title, context, false);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.TitleBlock_ID");
        GridLayout glContent = new GridLayout();
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.grpGeneral = new Group(this.cmpContent, 0);
        GridLayout glGeneral = new GridLayout();
        glGeneral.verticalSpacing = 10;
        glGeneral.marginHeight = 7;
        glGeneral.marginWidth = 7;
        GridData gdCMPGeneral = new GridData(770);
        this.grpGeneral.setLayoutData((Object)gdCMPGeneral);
        this.grpGeneral.setLayout((Layout)glGeneral);
        this.grpGeneral.setText(Messages.getString("TitlePropertiesSheet.Label.TitleArea"));
        Composite cmpGeneralTop = new Composite((Composite)this.grpGeneral, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        cmpGeneralTop.setLayout((Layout)layout);
        cmpGeneralTop.setLayoutData((Object)new GridData(768));
        Label lblAnchor = new Label(cmpGeneralTop, 0);
        GridData gdLBLAnchor = new GridData();
        lblAnchor.setLayoutData((Object)gdLBLAnchor);
        lblAnchor.setText(Messages.getString("TitlePropertiesSheet.Label.Anchor"));
        this.cmbAnchor = this.getContext().getUIFactory().createChartCombo(cmpGeneralTop, 12, (EObject)this.getBlockForProcessing(), "anchor", ChartDefaultValueUtil.getDefaultTitle((Chart)this.getChart()).getAnchor().getName());
        GridData gdCBAnchor = new GridData(768);
        this.cmbAnchor.setLayoutData((Object)gdCBAnchor);
        this.cmbAnchor.addSelectionListener((SelectionListener)this);
        this.cmbAnchor.getWidget().setVisibleItemCount(30);
        Label lblStretch = new Label(cmpGeneralTop, 0);
        GridData gdLBLStretch = new GridData();
        lblStretch.setLayoutData((Object)gdLBLStretch);
        lblStretch.setText(Messages.getString("TitlePropertiesSheet.Label.Stretch"));
        this.cmbStretch = this.getContext().getUIFactory().createChartCombo(cmpGeneralTop, 12, (EObject)this.getBlockForProcessing(), "stretch", ChartDefaultValueUtil.getDefaultTitle((Chart)this.getChart()).getStretch().getName());
        GridData gdCBStretch = new GridData(768);
        this.cmbStretch.setLayoutData((Object)gdCBStretch);
        this.cmbStretch.addSelectionListener((SelectionListener)this);
        Label lblBackground = new Label(cmpGeneralTop, 0);
        GridData gdLBLBackground = new GridData();
        lblBackground.setLayoutData((Object)gdLBLBackground);
        lblBackground.setText(Messages.getString("TitlePropertiesSheet.Label.Background"));
        int fillStyels = 27;
        this.fccBackground = new FillChooserComposite(cmpGeneralTop, 0, fillStyels |= this.getContext().getUIFactory().supportAutoUI() ? 4 : fillStyels, this.getContext(), this.getBlockForProcessing().getBackground());
        GridData gdFCCBackground = new GridData(768);
        this.fccBackground.setLayoutData(gdFCCBackground);
        this.fccBackground.addListener(this);
        this.grpOutline = new Group((Composite)this.grpGeneral, 0);
        GridData gdGRPOutline = new GridData(768);
        this.grpOutline.setLayoutData((Object)gdGRPOutline);
        this.grpOutline.setLayout((Layout)new FillLayout());
        this.grpOutline.setText(Messages.getString("TitlePropertiesSheet.Label.Outline"));
        int lineStyles = 15;
        this.liacOutline = new LineAttributesComposite((Composite)this.grpOutline, 0, lineStyles |= this.getContext().getUIFactory().supportAutoUI() ? 16 : lineStyles, this.getContext(), this.getBlockForProcessing().getOutline(), ChartDefaultValueUtil.getDefaultTitle((Chart)this.getChart()).getOutline());
        this.liacOutline.addListener(this);
        this.ic = this.getContext().getUIFactory().createChartInsetsComposite((Composite)this.grpGeneral, 0, 2, this.getBlockForProcessing().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider(), this.getContext(), ChartDefaultValueUtil.getDefaultTitle((Chart)this.getChart()).getInsets());
        GridData gdInsets = new GridData(768);
        this.ic.setLayoutData((Object)gdInsets);
        this.populateLists();
        return this.cmpContent;
    }

    public void handleEvent(Event event) {
        if (event.widget.equals((Object)this.fccBackground)) {
            this.getBlockForProcessing().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.liacOutline)) {
            boolean isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
            switch (event.type) {
                case 1: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"style", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 2: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"thickness", (Object)((Integer)event.data), (boolean)isUnset);
                    break;
                }
                case 3: {
                    this.getBlockForProcessing().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getBlockForProcessing().getOutline(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        }
    }

    private boolean isAnchorVertical(Anchor anchor) {
        return anchor.getValue() == 2 || anchor.getValue() == 6;
    }

    public void widgetSelected(SelectionEvent e) {
        String selectedStretch;
        Object oSource = e.getSource();
        if (oSource.equals(this.cmbAnchor)) {
            String selectedAnchor = this.cmbAnchor.getSelectedItemData();
            if (selectedAnchor != null) {
                boolean bAnchorVerticalOld = this.isAnchorVertical(this.getBlockForProcessing().getAnchor());
                this.getBlockForProcessing().setAnchor(Anchor.getByName((String)selectedAnchor));
                boolean bAnchorVerticalNew = this.isAnchorVertical(this.getBlockForProcessing().getAnchor());
                if (bAnchorVerticalOld != bAnchorVerticalNew) {
                    double rotationOld = this.getBlockForProcessing().getLabel().getCaption().getFont().getRotation();
                    double rotationNew = rotationOld >= 0.0 ? 90.0 - rotationOld : -90.0 - rotationOld;
                    this.getBlockForProcessing().getLabel().getCaption().getFont().setRotation(rotationNew);
                }
            }
        } else if (oSource.equals(this.cmbStretch) && (selectedStretch = this.cmbStretch.getSelectedItemData()) != null) {
            this.getBlockForProcessing().setStretch(Stretch.getByName((String)selectedStretch));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private LabelBlock getBlockForProcessing() {
        return this.getChart().getTitle();
    }

    private void populateLists() {
        NameSet ns = LiteralHelper.titleAnchorSet;
        this.cmbAnchor.setItems(ns.getDisplayNames());
        this.cmbAnchor.setItemData(ns.getNames());
        this.cmbAnchor.setSelection(this.getBlockForProcessing().getAnchor().getName());
        ns = LiteralHelper.stretchSet;
        this.cmbStretch.setItems(ns.getDisplayNames());
        this.cmbStretch.setItemData(ns.getNames());
        this.cmbStretch.setSelection(this.getBlockForProcessing().getStretch().getName());
    }
}

