/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.excel.BookmarkDef;
import org.eclipse.birt.report.engine.emitter.excel.ExcelXmlWriter;
import org.eclipse.birt.report.engine.emitter.excel.IExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelWriter
implements IExcelWriter {
    private ExcelXmlWriter writer;
    private ExcelXmlWriter tempWriter;
    private final ExcelContext context;
    private String tempFilePath;
    private int sheetIndex = 1;

    public ExcelWriter(ExcelContext context) {
        this.context = context;
    }

    @Override
    public void end() throws IOException {
        this.writer.end();
    }

    @Override
    public void endRow() {
        this.writer.endRow();
    }

    @Override
    public void endSheet(double[] coordinates, String oritentation, int pageWidth, int pageHeight, float leftMargin, float rightMargin, float topMargin, float bottomMargin) {
        this.writer.endSheet(coordinates, oritentation, pageWidth, pageHeight, leftMargin, rightMargin, topMargin, bottomMargin);
    }

    @Override
    public void outputData(String sheet, SheetData data, StyleEntry style, int column, int colSpan) throws IOException {
        this.outputData(data, style, column, colSpan);
    }

    @Override
    public void outputData(SheetData data, StyleEntry style, int column, int colSpan) throws IOException {
        this.writer.outputData(data, style, column, colSpan);
    }

    @Override
    public void start(IReportContent report, Map<StyleEntry, Integer> styles, HashMap<String, BookmarkDef> bookmarkList) throws IOException {
        this.writer = new ExcelXmlWriter(this.context);
        this.writer.setSheetIndex(this.sheetIndex);
        this.writer.start(report, styles, bookmarkList);
        this.copyOutputData();
    }

    private void copyOutputData() throws IOException {
        if (this.tempWriter != null) {
            this.tempWriter.close();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.tempFilePath), "UTF-8"));
                String line = reader.readLine();
                ExcelXmlWriter.XMLWriterXLS xlsWriter = this.writer.getWriter();
                while (line != null) {
                    xlsWriter.literal("\n");
                    xlsWriter.literal(line);
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                    reader = null;
                    File file = new File(this.tempFilePath);
                    if (file.exists() && file.isFile()) {
                        file.delete();
                    }
                    this.tempFilePath = null;
                    this.tempWriter = null;
                }
            }
        }
    }

    @Override
    public void startRow(double rowHeight) {
        this.writer.startRow(rowHeight);
    }

    @Override
    public void startSheet(String name) throws IOException {
        if (this.writer == null) {
            this.initializeWriterAsTempWriter();
        }
        this.writer.startSheet(name);
        ++this.sheetIndex;
    }

    @Override
    public void startSheet(double[] coordinates, String pageHeader, String pageFooter, String name) throws IOException {
        if (this.writer == null) {
            this.initializeWriterAsTempWriter();
        }
        this.writer.startSheet(coordinates, pageHeader, pageFooter, name);
        ++this.sheetIndex;
    }

    private void initializeWriterAsTempWriter() throws FileNotFoundException {
        String tempFolder = this.context.getTempFileDir();
        if (!tempFolder.endsWith("/") && !tempFolder.endsWith("\\")) {
            tempFolder = tempFolder.concat("/");
        }
        this.tempFilePath = String.valueOf(tempFolder) + "birt_xls_" + UUID.randomUUID().toString();
        FileOutputStream out = new FileOutputStream(this.tempFilePath);
        this.writer = this.tempWriter = new ExcelXmlWriter(out, this.context);
    }

    @Override
    public void endSheet() {
        this.writer.endSheet();
    }

    @Override
    public void startRow() {
        this.writer.startRow();
    }

    @Override
    public void outputData(int col, int row, int type, Object value) {
        this.writer.outputData(col, row, type, value);
    }

    @Override
    public String defineName(String cells) {
        return this.writer.defineName(cells);
    }
}

