/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUrlHandler
extends AbstractURLStreamHandlerService {
    private static final Logger logger = LoggerFactory.getLogger(ZkUrlHandler.class);
    private static final String SYNTAX = "zk: zk-node-path";
    private IZKClient zooKeeper;

    public ZkUrlHandler() {
    }

    public ZkUrlHandler(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) throws MalformedURLException {
            String path;
            super(url);
            if (url.getPath() == null || url.getPath().trim().length() == 0) {
                throw new MalformedURLException("Path can not be null or empty. Syntax: zk: zk-node-path");
            }
            if (url.getHost() != null && url.getHost().length() > 0 || url.getPort() != -1) {
                throw new MalformedURLException("Unsupported host/port in zookeeper url");
            }
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                throw new MalformedURLException("Unsupported query in zookeeper url");
            }
            if (url.getRef() != null && !(path = url.getPath().trim()).endsWith(".properties") && !path.endsWith(".json")) {
                throw new MalformedURLException("Fragments are only supported for '.properties' and '.json' files.");
            }
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return new ByteArrayInputStream(ZkPath.loadURL(ZkUrlHandler.this.zooKeeper, this.url.toString()));
            }
            catch (Exception e) {
                logger.error("Error opening zookeeper url", (Throwable)e);
                throw (IOException)new IOException("Error opening zookeeper url").initCause(e);
            }
        }
    }
}

