/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.InterpolationHelper;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKData;

public class ZooKeeperUtils {
    public static void copy(IZKClient source, IZKClient dest, String path) throws InterruptedException, KeeperException {
        for (String child : source.getChildren(path)) {
            child = path + "/" + child;
            if (dest.exists(child) != null) continue;
            byte[] data = source.getData(child);
            ZooKeeperUtils.set(dest, child, data);
            ZooKeeperUtils.copy(source, dest, child);
        }
    }

    public static void copy(IZKClient zk, String from, String to) throws InterruptedException, KeeperException {
        for (String child : zk.getChildren(from)) {
            String fromChild = from + "/" + child;
            String toChild = to + "/" + child;
            if (zk.exists(toChild) != null) continue;
            byte[] data = zk.getData(fromChild);
            ZooKeeperUtils.set(zk, toChild, data);
            ZooKeeperUtils.copy(zk, fromChild, toChild);
        }
    }

    public static void add(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) == null) {
            zooKeeper.createOrSetWithParents(path, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        } else {
            String data = zooKeeper.getStringData(path);
            if (data == null) {
                data = "";
            }
            if (data.length() > 0) {
                data = data + " ";
            }
            data = data + value;
            zooKeeper.setData(path, data);
        }
    }

    public static void remove(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) != null) {
            String data = zooKeeper.getStringData(path);
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList(data.split(" ")));
            boolean changed = false;
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                String v = (String)it.next();
                if (!v.matches(value)) continue;
                it.remove();
                changed = true;
            }
            if (changed) {
                data = "";
                for (String part : parts) {
                    if (data.length() > 0) {
                        data = data + " ";
                    }
                    data = data + part;
                }
                zooKeeper.setData(path, data);
            }
        }
    }

    public static String get(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        return zooKeeper.getStringData(path);
    }

    public static void set(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        zooKeeper.createOrSetWithParents(path, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    public static void set(IZKClient zooKeeper, String path, byte[] value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) != null) {
            zooKeeper.setByteData(path, value);
        }
        try {
            zooKeeper.createBytesNodeWithParents(path, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            zooKeeper.setByteData(path, value);
        }
    }

    public static void create(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        zooKeeper.createWithParents(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    public static void createDefault(IZKClient zooKeeper, String path, String value) throws InterruptedException, KeeperException {
        if (zooKeeper.exists(path) == null) {
            zooKeeper.createWithParents(path, value, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    public static Properties getProperties(IZKClient zooKeeper, String path, Watcher watcher) throws InterruptedException, KeeperException {
        ZKData zkData = zooKeeper.getZKStringData(path, watcher);
        String value = (String)zkData.getData();
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Properties getProperties(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException {
        ZKData zkData = zooKeeper.getZKStringData(path);
        String value = (String)zkData.getData();
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return properties;
    }

    public static void setProperties(IZKClient zooKeeper, String path, Properties properties) throws InterruptedException, KeeperException {
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            zooKeeper.setData(path, writer.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static String getSubstitutedPath(IZKClient zooKeeper, String path) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        String normaledPath;
        String string = normaledPath = path != null && path.contains("#") ? path.substring(0, path.lastIndexOf("#")) : path;
        if (normaledPath != null && zooKeeper.exists(normaledPath) != null) {
            String data = new String(ZkPath.loadURL(zooKeeper, path), "UTF-8");
            return ZooKeeperUtils.getSubstitutedData(zooKeeper, data);
        }
        return null;
    }

    public static String getSubstitutedData(final IZKClient zooKeeper, String data) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("data", data);
        InterpolationHelper.performSubstitution(props, new InterpolationHelper.SubstitutionCallback(){

            @Override
            public String getValue(String key) {
                if (key.startsWith("zk:")) {
                    try {
                        return new String(ZkPath.loadURL(zooKeeper, key), "UTF-8");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        });
        return (String)props.get("data");
    }
}

