/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fusesource.fabric.api.ProfileRequirements;

public class FabricRequirements {
    private List<ProfileRequirements> profileRequirements = new ArrayList<ProfileRequirements>();

    public FabricRequirements() {
    }

    public FabricRequirements(List<ProfileRequirements> profileRequirements) {
        this();
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public List<ProfileRequirements> getProfileRequirements() {
        return this.profileRequirements;
    }

    public void setProfileRequirements(List<ProfileRequirements> profileRequirements) {
        this.profileRequirements = profileRequirements;
        this.sortProfilesRequirements();
    }

    public ProfileRequirements getOrCreateProfileRequirement(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements == null) {
            requirements = new ProfileRequirements(profile);
            this.profileRequirements.add(requirements);
        }
        return requirements;
    }

    public ProfileRequirements findProfileRequirements(String profile) {
        for (ProfileRequirements profileRequirement : this.profileRequirements) {
            if (!profile.equals(profileRequirement.getProfile())) continue;
            return profileRequirement;
        }
        return null;
    }

    public void removeProfileRequirements(String profile) {
        ProfileRequirements requirements = this.findProfileRequirements(profile);
        if (requirements != null) {
            this.profileRequirements.remove(requirements);
        }
    }

    public void addOrUpdateProfileRequirements(ProfileRequirements requirement) {
        this.removeProfileRequirements(requirement.getProfile());
        this.profileRequirements.add(requirement);
        this.sortProfilesRequirements();
    }

    protected void sortProfilesRequirements() {
        Collections.sort(this.profileRequirements);
    }
}

