/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.fusesource.fabric.api.FabricRequirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirementsJson {
    private static final transient Logger LOG = LoggerFactory.getLogger(RequirementsJson.class);
    private static ObjectMapper mapper = new ObjectMapper();

    public static void writeRequirements(OutputStream out, FabricRequirements value) throws IOException {
        mapper.writeValue(out, (Object)value);
    }

    public static String toJSON(FabricRequirements answer) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)answer);
            return writer.toString();
        }
        catch (IOException e) {
            LOG.warn("Failed to marshal to JSON: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public static FabricRequirements readRequirements(InputStream in) throws IOException {
        return (FabricRequirements)mapper.readValue(in, FabricRequirements.class);
    }

    public static FabricRequirements fromJSON(String json) throws IOException {
        if (json == null) {
            return null;
        }
        if ((json = json.trim()).length() == 0 || json.equals("{}")) {
            return null;
        }
        return (FabricRequirements)mapper.reader(FabricRequirements.class).readValue(json);
    }

    static {
        mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
    }
}

