/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.Agent;
import com.fusesource.ide.jvmmonitor.internal.agent.ClassVisitorImpl;
import com.fusesource.ide.jvmmonitor.internal.agent.Config;
import com.fusesource.ide.jvmmonitor.internal.agent.asm.ClassReader;
import com.fusesource.ide.jvmmonitor.internal.agent.asm.ClassWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Set;

public class ClassFileTransformerImpl
implements ClassFileTransformer {
    private Set<Class<?>> targetClasses;
    private Set<Class<?>> transformedClasses;

    public ClassFileTransformerImpl(Set<Class<?>> targetClasses, Set<Class<?>> transformedClasses) {
        this.targetClasses = targetClasses;
        this.transformedClasses = transformedClasses;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.isProfiledClassLoader(loader) || !this.matches(className, Config.getInstance().profiledPackages) || this.matches(className, Config.getInstance().ignoredPackages)) {
            return classfileBuffer;
        }
        this.targetClasses.add(classBeingRedefined);
        this.transformedClasses.add(classBeingRedefined);
        Agent.logInfo("Instrumented class: %s", className);
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(1);
        ClassVisitorImpl visitor = new ClassVisitorImpl(writer, className);
        reader.accept(visitor, 2);
        return writer.toByteArray();
    }

    private boolean matches(String className, Set<String> packages) {
        String packageName;
        if (packages.isEmpty()) {
            return false;
        }
        if (className.contains("/")) {
            packageName = className.substring(0, className.lastIndexOf(47)).replace('/', '.');
        } else {
            if (className.startsWith("$")) {
                return false;
            }
            packageName = "<default>";
        }
        for (String pkg : packages) {
            if (!(pkg.endsWith("*") ? packageName.concat(".").startsWith(pkg.substring(0, pkg.length() - 1)) : packageName.equals(pkg))) continue;
            return true;
        }
        return false;
    }

    private boolean isProfiledClassLoader(ClassLoader loader) {
        if (Config.getInstance().profiledClassLoaders.isEmpty()) {
            return true;
        }
        for (String classLoader : Config.getInstance().profiledClassLoaders) {
            if (loader == null || !loader.getClass().getName().equals(classLoader)) continue;
            return true;
        }
        return false;
    }
}

