/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.Agent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Config {
    private static final String SEPARATOR = ",";
    private boolean profilerEnabled;
    private boolean autoDumpEnabled;
    private String dumpDir;
    protected Set<String> ignoredPackages = new LinkedHashSet<String>();
    protected Set<String> profiledPackages = new LinkedHashSet<String>();
    protected Set<String> profiledClassLoaders = new LinkedHashSet<String>();
    private static Config config;

    private Config() {
        this.load();
    }

    protected static synchronized Config getInstance() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    protected void addElements(Set<String> list, String string) {
        if (string == null) {
            return;
        }
        String[] elements = string.split(SEPARATOR);
        if (elements != null && elements.length > 0) {
            String[] stringArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                list.add(element.trim());
                ++n2;
            }
        }
    }

    protected boolean isProfilerEnabled() {
        return this.profilerEnabled;
    }

    protected void setProfilerEnabled(boolean enabled) {
        this.profilerEnabled = enabled;
    }

    protected boolean isAutoDumpEnabled() {
        return this.autoDumpEnabled;
    }

    protected void setAutoDumpEnabled(boolean enabled) {
        this.autoDumpEnabled = enabled;
    }

    protected String getDumpDir() {
        return this.dumpDir;
    }

    protected void setDumpDir(String dir) {
        this.dumpDir = dir;
    }

    private void load() {
        String fileName = System.getProperty("jvmmonitor.config");
        if (fileName != null) {
            this.setProperties(fileName);
        }
        this.profilerEnabled = System.getProperty("jvmmonitor.deferred", Boolean.TRUE.toString()).toLowerCase().trim().equals(Boolean.FALSE.toString());
        this.autoDumpEnabled = System.getProperty("jvmmonitor.dump", Boolean.FALSE.toString()).toLowerCase().trim().equals(Boolean.TRUE.toString());
        String outputDirStr = System.getProperty("jvmmonitor.dump.dir", this.getDefaultDir());
        String ignoredPackagesStr = System.getProperty("jvmmonitor.ignored.packages");
        String profiledPackagesStr = System.getProperty("jvmmonitor.profiled.packages");
        String profiledClassLoadersStr = System.getProperty("jvmmonitor.profiled.classloaders");
        this.dumpDir = outputDirStr.trim();
        if (!this.dumpDir.endsWith(File.separator)) {
            this.dumpDir = this.dumpDir.concat(File.separator);
        }
        this.ignoredPackages.add("com.fusesource.ide.jvmmonitor.internal.agent.*");
        if (ignoredPackagesStr != null) {
            this.ignoredPackages.clear();
            this.addElements(this.ignoredPackages, ignoredPackagesStr);
        }
        if (profiledPackagesStr != null) {
            this.profiledPackages.clear();
            this.addElements(this.profiledPackages, profiledPackagesStr);
        }
        if (profiledClassLoadersStr != null) {
            this.profiledClassLoaders.clear();
            this.addElements(this.profiledClassLoaders, profiledClassLoadersStr);
        }
    }

    private String getDefaultDir() {
        String dir = System.getProperty("user.home");
        if (dir != null) {
            return dir;
        }
        dir = System.getProperty("user.dir");
        if (dir != null) {
            return dir;
        }
        return new File(".").getAbsolutePath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProperties(String fileName) {
        if (fileName == null) {
            return;
        }
        FileInputStream inputStream = null;
        try {
            try {
                inputStream = new FileInputStream(fileName);
                Properties properties = new Properties();
                properties.load(inputStream);
                for (Map.Entry<Object, Object> set : properties.entrySet()) {
                    System.setProperty((String)set.getKey(), (String)set.getValue());
                }
                return;
            }
            catch (FileNotFoundException e) {
                Agent.logError(e, "Cannot open the specified configuration file:\n\t%s\n", fileName);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (IOException e) {
                Agent.logError(e, "Cannot open the specified configuration file:\n\t%s\n", fileName);
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

