/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.Agent;
import com.fusesource.ide.jvmmonitor.internal.agent.ClassFileTransformerImpl;
import com.fusesource.ide.jvmmonitor.internal.agent.Config;
import com.fusesource.ide.jvmmonitor.internal.agent.CpuBciProfiler;
import com.fusesource.ide.jvmmonitor.internal.agent.CpuBciProfilerMXBean;
import com.fusesource.ide.jvmmonitor.internal.agent.TransformStatusCompositeData;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.HashSet;
import java.util.Set;

public class CpuBciProfilerMXBeanImpl
implements CpuBciProfilerMXBean {
    Instrumentation inst;
    ClassFileTransformerImpl classFileTransformer;
    private Set<Class<?>> targetClasses;
    private Set<Class<?>> transformedClasses;
    private boolean interrupted;

    public CpuBciProfilerMXBeanImpl(Instrumentation inst) throws IOException {
        this.inst = inst;
        this.transformedClasses = new HashSet();
        this.targetClasses = new HashSet();
        this.classFileTransformer = new ClassFileTransformerImpl(this.transformedClasses, this.targetClasses);
        this.interrupted = false;
        CpuBciProfiler.initialize();
        if (Config.getInstance().isProfilerEnabled()) {
            this.setRunning(true);
        }
    }

    @Override
    public void transformClasses() {
        new Thread(){

            @Override
            public void run() {
                try {
                    CpuBciProfilerMXBeanImpl.this.inst.addTransformer(CpuBciProfilerMXBeanImpl.this.classFileTransformer, true);
                    CpuBciProfilerMXBeanImpl.this.retransformClasses();
                    CpuBciProfilerMXBeanImpl.this.inst.removeTransformer(CpuBciProfilerMXBeanImpl.this.classFileTransformer);
                }
                catch (Throwable t) {
                    Agent.logError(t, "Cannot transform the classes.", new Object[0]);
                }
            }
        }.start();
    }

    @Override
    public TransformStatusCompositeData getTransformStatus() {
        return new TransformStatusCompositeData(this.targetClasses.size(), this.transformedClasses.size());
    }

    @Override
    public void interruptTransform() {
        this.interrupted = true;
    }

    @Override
    public void setRunning(boolean run) {
        if (run) {
            this.inst.addTransformer(this.classFileTransformer, true);
            Config.getInstance().setProfilerEnabled(true);
        } else {
            try {
                this.inst.removeTransformer(this.classFileTransformer);
                Config.getInstance().setProfilerEnabled(false);
            }
            catch (Throwable t) {
                Agent.logError(t, "Cannot suspend the CPU profiler.", new Object[0]);
            }
        }
    }

    @Override
    public boolean isRunning() {
        try {
            return Config.getInstance().isProfilerEnabled();
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot get the profiler running state.", new Object[0]);
            return false;
        }
    }

    @Override
    public void clear() {
        try {
            CpuBciProfiler.getModel().clear();
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot clear the CPU profiling data.", new Object[0]);
        }
    }

    @Override
    public String dump() {
        try {
            return CpuBciProfiler.getModel().dump();
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot get the CPU profiling data.", new Object[0]);
            return "";
        }
    }

    @Override
    public void dumpToFile() {
        try {
            CpuBciProfiler.getModel().dumpToFile();
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot dump the CPU profiling data to file.", new Object[0]);
        }
    }

    @Override
    public String getDumpDir() {
        return Config.getInstance().getDumpDir();
    }

    @Override
    public void setDumpDir(String dir) {
        Config.getInstance().setDumpDir(dir);
    }

    @Override
    public String getVersion() {
        return "3.7.0";
    }

    @Override
    public void setFilter(String key, String value) {
        if ("jvmmonitor.profiled.packages".equals(key)) {
            Config.getInstance().profiledPackages.clear();
            Config.getInstance().addElements(Config.getInstance().profiledPackages, value);
            this.targetClasses.clear();
            Class[] classArray = this.inst.getAllLoadedClasses();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                String className = clazz.getName();
                if (!className.startsWith("[") && this.matchs(className, Config.getInstance().profiledPackages)) {
                    this.targetClasses.add(clazz);
                }
                ++n2;
            }
        }
    }

    @Override
    public String[] getProfiledClassloaders() {
        Set<String> list = Config.getInstance().profiledClassLoaders;
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getProfiledPackages() {
        Set<String> list = Config.getInstance().profiledPackages;
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getIgnoredPackages() {
        Set<String> list = Config.getInstance().ignoredPackages;
        return list.toArray(new String[list.size()]);
    }

    void retransformClasses() {
        this.interrupted = false;
        HashSet transformedTargetClasses = new HashSet(this.transformedClasses);
        transformedTargetClasses.retainAll(this.targetClasses);
        Set<Class<?>> classesToTransform = this.getClassesToTransform(transformedTargetClasses);
        this.transformedClasses.clear();
        this.transformedClasses.addAll(transformedTargetClasses);
        for (Class<?> clazz : classesToTransform) {
            if (this.interrupted) {
                this.transformedClasses.retainAll(this.targetClasses);
                return;
            }
            try {
                this.inst.retransformClasses(clazz);
                Agent.logInfo("Retransformed class: %s", clazz);
            }
            catch (UnmodifiableClassException e) {
                Agent.logError(e, "Cannot retransform class: %s", new Object[0]);
            }
            catch (InternalError internalError) {
                // empty catch block
            }
        }
        this.transformedClasses.clear();
        this.transformedClasses.addAll(this.targetClasses);
    }

    private Set<Class<?>> getClassesToTransform(Set<Class<?>> transformedTargetClasses) {
        HashSet classes = new HashSet();
        classes.addAll(this.targetClasses);
        classes.addAll(this.transformedClasses);
        classes.removeAll(transformedTargetClasses);
        return classes;
    }

    private boolean matchs(String className, Set<String> packages) {
        if (packages.isEmpty()) {
            return false;
        }
        String packageName = className.contains(".") ? className.substring(0, className.lastIndexOf(46)) : "<default>";
        for (String pkg : packages) {
            if (!(pkg.endsWith("*") ? packageName.startsWith(pkg.substring(0, pkg.length() - 2)) : packageName.equals(pkg))) continue;
            return true;
        }
        return false;
    }
}

