/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.asm.Type;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FrameNode {
    private String className;
    private String methodName;
    private Map<String, FrameNode> childFrames;
    private FrameNode parentFrame;
    private long stepIntoTime;
    private long totalTime;
    private long overheadTime;
    private int count;

    protected FrameNode(FrameNode parent, String clazz, String method) {
        this.parentFrame = parent;
        this.className = clazz;
        this.methodName = method;
        this.childFrames = new ConcurrentHashMap<String, FrameNode>();
        this.stepIntoTime = 0L;
        this.totalTime = 0L;
        this.overheadTime = 0L;
        this.count = 0;
    }

    protected FrameNode getChild(String clazz, String method) {
        FrameNode frame = this.childFrames.get(String.valueOf(clazz) + '.' + method);
        if (frame == null) {
            frame = new FrameNode(this, clazz, method);
            this.childFrames.put(String.valueOf(clazz) + '.' + method, frame);
        }
        return frame;
    }

    protected void setStepIntoTime(long time, long overhead) {
        this.stepIntoTime = time;
        this.overheadTime += overhead;
        ++this.count;
    }

    protected void setStepReturnTime(long time, long overhead) {
        this.totalTime += time - this.stepIntoTime;
        this.overheadTime += overhead;
        this.stepIntoTime = 0L;
    }

    protected void incrementOverhead(long overhead) {
        this.overheadTime += overhead;
    }

    protected FrameNode getParent() {
        return this.parentFrame;
    }

    protected FrameNode searchFrame(String clazz, String method) {
        if (this.className.equals(clazz) && this.methodName.equals(method)) {
            return this;
        }
        if (this.parentFrame == null) {
            return this;
        }
        return this.parentFrame.searchFrame(clazz, method);
    }

    protected void dump(PrintWriter writer, long time, int nest) {
        String name = this.getFrameName();
        long actualTotalTime = this.totalTime - this.overheadTime;
        if (this.stepIntoTime != 0L) {
            actualTotalTime += time - this.stepIntoTime;
        }
        int i = 0;
        while (i < nest) {
            writer.print("\t");
            ++i;
        }
        writer.printf("<frame name=\"%s\" cnt=\"%d\" time=\"%d\"", name, this.count, Math.max(actualTotalTime, 0L));
        if (this.childFrames.size() > 0) {
            writer.println(">");
            for (FrameNode frameNode : this.childFrames.values()) {
                frameNode.dump(writer, time, nest + 1);
            }
            i = 0;
            while (i < nest) {
                writer.print("\t");
                ++i;
            }
            writer.println("</frame>");
        } else {
            writer.println("/>");
        }
    }

    protected void dump(StringBuffer buffer, long time, int nest) {
        String name = this.getFrameName();
        long actualTotalTime = this.totalTime - this.overheadTime;
        if (this.stepIntoTime != 0L) {
            actualTotalTime += time - this.stepIntoTime;
        }
        int i = 0;
        while (i < nest) {
            buffer.append('\t');
            ++i;
        }
        buffer.append("<frame name=\"").append(name).append("\" cnt=\"").append(this.count).append("\" time=\"").append(Math.max(actualTotalTime, 0L)).append("\"");
        if (this.childFrames.size() > 0) {
            buffer.append(">\n");
            for (FrameNode frameNode : this.childFrames.values()) {
                frameNode.dump(buffer, time, nest + 1);
            }
            i = 0;
            while (i < nest) {
                buffer.append('\t');
                ++i;
            }
            buffer.append("</frame>\n");
        } else {
            buffer.append("/>\n");
        }
    }

    private String getFrameName() {
        String clazz = this.className.replace('/', '.');
        StringBuilder builder = new StringBuilder();
        builder.append(this.methodName.substring(0, this.methodName.indexOf(40) + 1));
        Type[] types = Type.getArgumentTypes(this.methodName.substring(this.methodName.indexOf(40)));
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Type.getType(types[i].getDescriptor()).getClassName());
            ++i;
        }
        builder.append(')');
        String method = builder.toString();
        method = method.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return String.valueOf(clazz) + '.' + method;
    }
}

