/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.asm.Label;
import com.fusesource.ide.jvmmonitor.internal.agent.asm.MethodAdapter;
import com.fusesource.ide.jvmmonitor.internal.agent.asm.MethodVisitor;

public class MethodVisitorImpl
extends MethodAdapter {
    private String className;
    private String methodName;
    private boolean isClinit;

    public MethodVisitorImpl(MethodVisitor methodVisitor, String className, String methodName) {
        super(methodVisitor);
        this.className = className;
        this.methodName = methodName;
        this.isClinit = methodName.startsWith("<clinit>");
    }

    @Override
    public void visitCode() {
        this.instrumentMethodInvocation("stepInto", this.className, this.methodName);
        super.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (172 <= opcode && opcode <= 177 || 191 == opcode) {
            this.instrumentMethodInvocation("stepReturn", this.className, this.methodName);
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        handler.info = type;
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        if (label.info != null) {
            this.instrumentMethodInvocation("dropToFrame", this.className, this.methodName, (String)label.info);
        }
    }

    private void instrumentMethodInvocation(String name, String ... args) {
        if (this.isClinit) {
            return;
        }
        String desc = null;
        if (args.length == 2) {
            desc = "(Ljava/lang/String;Ljava/lang/String;)V";
        } else if (args.length == 3) {
            desc = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
        } else {
            return;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.visitLdcInsn(arg);
            ++n2;
        }
        super.visitMethodInsn(184, "org/jvmmonitor/internal/agent/CpuBciProfiler", name, desc);
    }
}

