/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.Agent;
import com.fusesource.ide.jvmmonitor.internal.agent.Config;
import com.fusesource.ide.jvmmonitor.internal.agent.ThreadNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class RuntimeModel
implements Runnable {
    private Map<String, ThreadNode> threadNodes = new ConcurrentHashMap<String, ThreadNode>();

    protected RuntimeModel() {
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    @Override
    public void run() {
        Config.getInstance().setProfilerEnabled(false);
        if (Config.getInstance().isAutoDumpEnabled()) {
            this.doDumpToFile();
        }
    }

    protected ThreadNode getThread(String thread) {
        ThreadNode threadNode = this.threadNodes.get(thread);
        if (threadNode == null) {
            threadNode = new ThreadNode(thread);
            this.threadNodes.put(thread, threadNode);
        }
        return threadNode;
    }

    protected void clear() {
        this.threadNodes.clear();
    }

    protected String dump() throws Exception {
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() {
                return RuntimeModel.this.doDump();
            }
        };
        return (String)callable.call();
    }

    protected void dumpToFile() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RuntimeModel.this.doDumpToFile();
            }
        };
        runnable.run();
    }

    protected String doDump() {
        Date currentDate = new Date();
        String date = new SimpleDateFormat("yyyy/MM/dd").format(currentDate);
        String time = new SimpleDateFormat("HH:mm:ss").format(currentDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<?JvmMonitor version=\"");
        buffer.append("3.7.0");
        buffer.append("\"?>\n");
        buffer.append("<cpu-profile date=\"").append(date).append(' ').append(time).append("\" ");
        buffer.append("runtime=\"").append(this.getRuntime()).append("\" ");
        buffer.append("mainClass=\"").append(this.getMainClass()).append("\" ");
        buffer.append("arguments=\"").append(this.getJvmArguments()).append("\">\n");
        long currentTime = System.currentTimeMillis();
        for (ThreadNode threadNode : this.threadNodes.values()) {
            threadNode.dump(buffer, currentTime);
        }
        buffer.append("</cpu-profile>");
        return buffer.toString();
    }

    protected void doDumpToFile() {
        Date currentDate = new Date();
        String date = new SimpleDateFormat("yyyy/MM/dd").format(currentDate);
        String time = new SimpleDateFormat("HH:mm:ss").format(currentDate);
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(this.getFile(currentDate))));
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.print("<?JvmMonitor version=\"");
                writer.print("3.7.0");
                writer.println("\"?>");
                writer.printf("<cpu-profile date=\"%s %s\" ", date, time);
                writer.printf("runtime=\"%s\" ", this.getRuntime());
                writer.printf("mainClass=\"%s\" ", this.getMainClass());
                writer.printf("arguments=\"%s\">\n", this.getJvmArguments());
                writer.println("");
                long currentTime = System.currentTimeMillis();
                for (ThreadNode threadNode : this.threadNodes.values()) {
                    threadNode.dump(writer, currentTime);
                }
                writer.println("</cpu-profile>");
                writer.flush();
            }
            catch (IOException e) {
                Agent.logError(e, "Writing into a dump file failed.\nPlease check the output directory \"%s\" specified in configuration file.\n", Config.getInstance().getDumpDir());
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getRuntime() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getName();
    }

    private String getMainClass() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(false, false);
        int n = threadInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            if (threadInfo.getThreadName().equals("main")) {
                StackTraceElement[] elements = threadInfo.getStackTrace();
                if (elements == null || elements.length == 0) {
                    return "";
                }
                StackTraceElement lastElement = elements[elements.length - 1];
                return lastElement.getClassName();
            }
            ++n2;
        }
        return "";
    }

    private String getJvmArguments() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMXBean.getInputArguments();
        StringBuffer buffer = new StringBuffer();
        for (String argument : arguments) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(argument);
        }
        return buffer.toString();
    }

    private File getFile(Date date) {
        String time = new SimpleDateFormat("HHmmss").format(date);
        String fileName = String.valueOf(Config.getInstance().getDumpDir()) + "jvmmonitor_" + time + ".cpu";
        return new File(fileName);
    }
}

