/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.agent;

import com.fusesource.ide.jvmmonitor.internal.agent.FrameNode;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadNode {
    private String thread;
    private FrameNode currentFrame;
    private Map<String, FrameNode> rootFrames;

    protected ThreadNode(String thread) {
        this.thread = thread;
        this.rootFrames = new ConcurrentHashMap<String, FrameNode>();
    }

    protected FrameNode getRootFrame(String className, String methodName) {
        FrameNode frame = this.rootFrames.get(String.valueOf(className) + '.' + methodName);
        if (frame == null) {
            frame = new FrameNode(null, className, methodName);
            this.rootFrames.put(String.valueOf(className) + '.' + methodName, frame);
        }
        return frame;
    }

    protected FrameNode getCurrentFrame() {
        return this.currentFrame;
    }

    protected void setCurrentFrame(FrameNode frame) {
        this.currentFrame = frame;
    }

    protected void dump(PrintWriter writer, long time) {
        Collection<FrameNode> frameNodes = this.rootFrames.values();
        if (frameNodes.size() == 0) {
            return;
        }
        writer.printf("\t<thread name=\"%s\">", this.thread);
        writer.println("");
        for (FrameNode frameNode : frameNodes) {
            frameNode.dump(writer, time, 2);
        }
        writer.println("\t</thread>");
    }

    protected void dump(StringBuffer buffer, long time) {
        Collection<FrameNode> frameNodes = this.rootFrames.values();
        if (frameNodes.size() == 0) {
            return;
        }
        buffer.append("\t<thread name=\"").append(this.thread).append("\">\n");
        for (FrameNode frameNode : frameNodes) {
            frameNode.dump(buffer, time, 2);
        }
        buffer.append("\t</thread>\n");
    }
}

