/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.fmc.camel.facade;

import com.fusesource.fmc.camel.facade.CamelFacade;
import com.fusesource.fmc.camel.facade.mbean.CamelPerformanceCounterMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelProcessorMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelRouteMBean;
import java.util.List;

public class CamelBackwardsCompatibleSupport {
    public static String dumpRoutesStatsAsXml(CamelFacade facade, String contextId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<camelContextStat").append(String.format(" id=\"%s\"", contextId)).append(">\n");
        List<CamelRouteMBean> routes = facade.getRoutes(contextId);
        List<CamelProcessorMBean> processors = facade.getProcessors(contextId);
        sb.append("  <routeStats>\n");
        for (CamelRouteMBean route : routes) {
            sb.append("    <routeStat").append(String.format(" id=\"%s\"", route.getRouteId()));
            sb.append(" ").append(CamelBackwardsCompatibleSupport.dumpStatsAsXmlAttributes(route)).append(">\n");
            sb.append("      <processorStats>\n");
            for (CamelProcessorMBean processor : processors) {
                if (!route.getRouteId().equals(processor.getRouteId())) continue;
                sb.append("        <processorStat").append(String.format(" id=\"%s\"", processor.getProcessorId()));
                sb.append(" ").append(CamelBackwardsCompatibleSupport.dumpStatsAsXmlAttributes(processor)).append("/>\n");
            }
            sb.append("      </processorStats>\n");
            sb.append("    </routeStat>\n");
        }
        sb.append("  </routeStats>\n");
        sb.append("</camelContextStat>");
        return sb.toString();
    }

    private static String dumpStatsAsXmlAttributes(CamelPerformanceCounterMBean mbean) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("exchangesCompleted=\"%s\"", mbean.getExchangesCompleted()));
        sb.append(String.format(" exchangesFailed=\"%s\"", mbean.getExchangesFailed()));
        sb.append(String.format(" minProcessingTime=\"%s\"", mbean.getMinProcessingTime()));
        sb.append(String.format(" maxProcessingTime=\"%s\"", mbean.getMaxProcessingTime()));
        sb.append(String.format(" totalProcessingTime=\"%s\"", mbean.getTotalProcessingTime()));
        sb.append(String.format(" lastProcessingTime=\"%s\"", mbean.getLastProcessingTime()));
        sb.append(String.format(" meanProcessingTime=\"%s\"", mbean.getMeanProcessingTime()));
        return sb.toString();
    }
}

