/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.fmc.camel.facade;

import com.fusesource.fmc.camel.facade.CamelFacade;
import com.fusesource.fmc.camel.facade.CamelFacadeCallback;
import com.fusesource.fmc.camel.facade.RemoteJMXCamelFacade;
import com.fusesource.fmc.camel.facade.mbean.CamelComponentMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelConsumerMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelContextMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelEndpointMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelFabricTracerMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelProcessorMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelRouteMBean;
import com.fusesource.fmc.camel.facade.mbean.CamelThreadPoolMBean;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.fusesource.fabric.service.JmxTemplateSupport;

public class JmxTemplateCamelFacade
implements CamelFacade {
    private final JmxTemplateSupport template;

    public JmxTemplateCamelFacade(JmxTemplateSupport template) {
        this.template = template;
    }

    public <T> T execute(final CamelFacadeCallback<T> callback) {
        return (T)this.template.execute(new JmxTemplateSupport.JmxConnectorCallback<T>(){

            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                RemoteJMXCamelFacade camelFacade = new RemoteJMXCamelFacade(connection);
                return callback.doWithCamelFacade(camelFacade);
            }
        });
    }

    @Override
    public List<CamelContextMBean> getCamelContexts() throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelContextMBean>>(){

            @Override
            public List<CamelContextMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getCamelContexts();
            }
        });
    }

    @Override
    public CamelContextMBean getCamelContext(final String managementName) {
        return this.execute(new CamelFacadeCallback<CamelContextMBean>(){

            @Override
            public CamelContextMBean doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getCamelContext(managementName);
            }
        });
    }

    @Override
    public CamelFabricTracerMBean getFabricTracer(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<CamelFabricTracerMBean>(){

            @Override
            public CamelFabricTracerMBean doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getFabricTracer(managementName);
            }
        });
    }

    @Override
    public List<CamelComponentMBean> getComponents(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelComponentMBean>>(){

            @Override
            public List<CamelComponentMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getComponents(managementName);
            }
        });
    }

    @Override
    public List<CamelRouteMBean> getRoutes(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelRouteMBean>>(){

            @Override
            public List<CamelRouteMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getRoutes(managementName);
            }
        });
    }

    @Override
    public List<CamelEndpointMBean> getEndpoints(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelEndpointMBean>>(){

            @Override
            public List<CamelEndpointMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getEndpoints(managementName);
            }
        });
    }

    @Override
    public List<CamelConsumerMBean> getConsumers(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelConsumerMBean>>(){

            @Override
            public List<CamelConsumerMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getConsumers(managementName);
            }
        });
    }

    @Override
    public List<CamelProcessorMBean> getProcessors(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelProcessorMBean>>(){

            @Override
            public List<CamelProcessorMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getProcessors(managementName);
            }
        });
    }

    @Override
    public List<CamelThreadPoolMBean> getThreadPools(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<List<CamelThreadPoolMBean>>(){

            @Override
            public List<CamelThreadPoolMBean> doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.getThreadPools(managementName);
            }
        });
    }

    @Override
    public String dumpRoutesStatsAsXml(final String managementName) throws Exception {
        return this.execute(new CamelFacadeCallback<String>(){

            @Override
            public String doWithCamelFacade(CamelFacade camel) throws Exception {
                return camel.dumpRoutesStatsAsXml(managementName);
            }
        });
    }
}

