/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus;

import com.fusesource.rider.sus.Activator;
import com.fusesource.rider.sus.InvalidUserOrPasswordException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.representation.Form;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Cookie;

public class LicenseDownloader {
    private static final String site = "https://fusesource.com/";
    private String userName;
    private String password;
    private Client client;
    private String authToken;
    private String eloquaToken;
    private String cookiesText;
    private String referrer = "https://fusesource.com/login";
    private String accept = "application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
    private String origin = "https://fusesource.com";
    private WebResource sharedResource;
    private boolean useEloquaGuid = false;
    private boolean loggedIn;

    public String downloadLicenseFile() throws InvalidUserOrPasswordException {
        if (!this.loggedIn) {
            this.login();
        }
        if (this.loggedIn) {
            Activator.getLogger().debug("Getting license...");
            this.referrer = "https://fusesource.com/account";
            this.origin = null;
            WebResource.Builder resource = this.createResource("account/license");
            ClientResponse answer = (ClientResponse)resource.get(ClientResponse.class);
            this.dump(answer);
            return (String)answer.getEntity(String.class);
        }
        return null;
    }

    public void login() throws InvalidUserOrPasswordException {
        this.client = Client.create();
        this.client.setFollowRedirects(Boolean.valueOf(false));
        this.sharedResource = this.client.resource(site);
        this.loggedIn = false;
        this.cookiesText = null;
        String login = "login";
        WebResource.Builder resource = this.createResource(login);
        ClientResponse answer = (ClientResponse)resource.get(ClientResponse.class);
        this.dump(answer);
        String html = (String)answer.getEntity(String.class);
        this.loadCookies(answer);
        this.authToken = this.parseHiddenFormField(html, "authenticity_token");
        if (this.useEloquaGuid) {
            this.eloquaToken = this.parseHiddenFormField(html, "eloqua_customer_guid");
        }
        resource = (WebResource.Builder)this.createResource(login).type("application/x-www-form-urlencoded");
        Form form = new Form();
        form.add("authenticity_token", this.authToken);
        if (this.eloquaToken != null) {
            form.add("eloqua_customer_guid", this.eloquaToken);
        }
        form.add("login", this.userName);
        form.add("password", this.password);
        answer = (ClientResponse)resource.post(ClientResponse.class, (Object)form);
        this.dump(answer);
        int status = answer.getStatus();
        if (status == 302) {
            this.loggedIn = true;
            this.loadCookies(answer);
            html = (String)answer.getEntity(String.class);
            String newToken = this.parseHiddenFormField(html, "authenticity_token");
            if (newToken != null) {
                Activator.getLogger().debug("New authToken: " + newToken);
                this.authToken = newToken;
            }
        } else {
            throw new InvalidUserOrPasswordException();
        }
    }

    protected void loadCookies(ClientResponse answer) {
        List cookies = (List)answer.getHeaders().get((Object)"Set-Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String cookieText : cookies) {
                Cookie cookie = Cookie.valueOf((String)cookieText);
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                String name = cookie.getName();
                Activator.getLogger().debug("Loaded cookie " + name);
                sb.append(name);
                sb.append("=");
                sb.append(cookie.getValue());
            }
            this.cookiesText = sb.toString();
            Activator.getLogger().debug("Sending cookies: " + this.cookiesText);
        }
    }

    protected String parseHiddenFormField(String html, String name) {
        String answer = null;
        Pattern regex = Pattern.compile("<input.*name=\"" + name + "\".*value=\"(\\w+)\".*>");
        Matcher matcher = regex.matcher(html);
        if (!matcher.find()) {
            Activator.getLogger().warning("Could not find hidden form field with name: " + name);
        } else {
            answer = matcher.group(1);
            Activator.getLogger().debug(String.valueOf(name) + " = " + answer);
        }
        return answer;
    }

    protected void dump(ClientResponse answer) {
        Activator.getLogger().debug("    Found: " + answer.getStatus());
        Activator.getLogger().debug("    Headers: " + answer.getHeaders());
    }

    protected WebResource.Builder createResource(String path) {
        WebResource.Builder resource = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)this.sharedResource.path(path).header("Accept", (Object)this.accept).header("Connection", (Object)"keep-alive")).header("Host", (Object)"fusesource.com")).header("Referer", (Object)this.referrer)).header("User-Agent", (Object)"Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_6; en-US) AppleWebKit/534.16 (KHTML, like Gecko) Chrome/10.0.648.204 Safari/534.16");
        if (this.origin != null) {
            resource = (WebResource.Builder)resource.header("Origin", (Object)this.origin);
        }
        if (this.cookiesText != null) {
            resource = (WebResource.Builder)resource.header("Cookie", (Object)this.cookiesText);
        }
        return resource;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

