/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus;

import com.fusesource.rider.sus.Activator;
import com.fusesource.rider.sus.LicenseStatus;
import com.fusesource.rider.sus.Subscriptions;
import com.fusesource.rider.sus.dialog.SubscriptionExpiredDialog;
import com.fusesource.rider.sus.dialog.SubscriptionExpiringDialog;
import com.fusesource.rider.sus.dialog.SubscriptionRequiredDialog;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SubscriptionChecker {
    private static transient Long lastShownWarning = null;
    private static DateFormat dateFormat = DateFormat.getDateInstance(1);
    private static AtomicBoolean flagSubscriptionRequiredDialog = new AtomicBoolean(false);
    private static AtomicBoolean flagSubscriptionExpiredDialog = new AtomicBoolean(false);
    private static AtomicBoolean flagSubscriptionAboutToExpireDialog = new AtomicBoolean(false);

    public static boolean isDevSubscriptionValid() {
        return SubscriptionChecker.isSubscriptionValid("Development");
    }

    public static boolean isProdSubscriptionValid() {
        return SubscriptionChecker.isSubscriptionValid("Production");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSubscriptionValid(String name) {
        try {
            Subscriptions subscriptions = Subscriptions.load();
            boolean production = name.toUpperCase().startsWith("P");
            LicenseStatus status = production ? subscriptions.getProdStatus() : subscriptions.getDevStatus();
            Date date = production ? subscriptions.getProdExpiryDate() : subscriptions.getDevExpiryDate();
            switch (status) {
                case Valid: {
                    return true;
                }
                case ExpiresSoon: {
                    SubscriptionChecker.displaySubscriptionAboutToExpireWarning(name, date);
                    return true;
                }
                case Expired: {
                    SubscriptionChecker.displaySubscriptionExpiredDialog(name, date);
                    return false;
                }
            }
            SubscriptionChecker.displaySubscriptionRequiredDialog(name);
            return false;
        }
        catch (Exception e) {
            SubscriptionChecker.displayFailedToloadSubscriptionDialog(e);
        }
        return false;
    }

    protected static void displaySubscriptionRequiredDialog(final String name) {
        SubscriptionChecker.runIfNotVisible(flagSubscriptionRequiredDialog, new Runnable(){

            @Override
            public void run() {
                SubscriptionRequiredDialog dialog = new SubscriptionRequiredDialog(SubscriptionChecker.getActiveShell(), name);
                dialog.open();
            }
        });
    }

    protected static void displaySubscriptionExpiredDialog(final String name, final Date date) {
        SubscriptionChecker.runIfNotVisible(flagSubscriptionExpiredDialog, new Runnable(){

            @Override
            public void run() {
                SubscriptionExpiredDialog dialog = new SubscriptionExpiredDialog(SubscriptionChecker.getActiveShell(), name, SubscriptionChecker.format(date));
                dialog.open();
            }
        });
    }

    protected static void displaySubscriptionAboutToExpireWarning(final String name, final Date date) {
        SubscriptionChecker.runIfNotVisible(flagSubscriptionAboutToExpireDialog, new Runnable(){

            @Override
            public void run() {
                if (lastShownWarning != null) {
                    long now = System.currentTimeMillis();
                    lastShownWarning = now;
                    if (now - lastShownWarning < 86400000L) {
                        return;
                    }
                }
                SubscriptionExpiringDialog dialog = new SubscriptionExpiringDialog(SubscriptionChecker.getActiveShell(), name, SubscriptionChecker.format(date));
                dialog.open();
            }
        });
    }

    protected static void runIfNotVisible(final AtomicBoolean flag, final Runnable runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (flag.compareAndSet(false, true)) {
                    runnable.run();
                    flag.set(false);
                }
            }
        });
    }

    protected static void displayFailedToloadSubscriptionDialog(Exception e) {
        Activator.getLogger().warning("Failed to load subscription: " + e, (Throwable)e);
    }

    protected static Shell getActiveShell() {
        try {
            Display current = Display.getCurrent();
            return current != null ? current.getActiveShell() : null;
        }
        catch (Exception e) {
            Activator.getLogger().debug("Caught: " + e, (Throwable)e);
            return null;
        }
    }

    protected static String format(Date date) {
        return dateFormat.format(date);
    }
}

