/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus;

import com.fusesource.rider.sus.Activator;
import com.fusesource.rider.sus.CannotRenameFileException;
import com.fusesource.rider.sus.CouldNotCreateDirectoryException;
import com.fusesource.rider.sus.InvalidUserOrPasswordException;
import com.fusesource.rider.sus.LicenseDownloader;
import com.fusesource.rider.sus.LicenseParser;
import com.fusesource.rider.sus.LicenseStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.fusesource.scalate.util.IOUtil;

public class Subscriptions {
    protected static final long EXPIRE_SOON = 604800000L;
    public static final String FUSESOURCE_DIR = ".fusesource";
    public static final String LICENSE_FILE = "license.key";
    protected static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static SimpleDateFormat timestampFormat = new SimpleDateFormat("-yyyy-MM-dd_kk-mm-ss-SSS");
    private String userName;
    private Date devExpiryDate;
    private Date prodExpiryDate;
    private Properties properties;

    public static Subscriptions load() throws Exception {
        File fuseDir = Subscriptions.getFuseSourceDirectory();
        if (fuseDir.exists() && fuseDir.isDirectory()) {
            File license = new File(fuseDir, LICENSE_FILE);
            if (license.exists() && license.isFile()) {
                LicenseParser parser = new LicenseParser();
                return parser.parse(new FileInputStream(license));
            }
            Activator.getLogger().debug("No FuseSource license file: " + license);
        } else {
            Activator.getLogger().debug("No FuseSource directory: " + fuseDir);
        }
        String userName = System.getProperty("user.name", null);
        return new Subscriptions(userName);
    }

    public static void downloadLicense(String userName, String password) throws CouldNotCreateDirectoryException, CannotRenameFileException, InvalidUserOrPasswordException {
        Activator.getLogger().debug("Attempting to download the subscription file!");
        LicenseDownloader downloader = new LicenseDownloader();
        downloader.setUserName(userName);
        downloader.setPassword(password);
        String license = downloader.downloadLicenseFile();
        File fuseDir = Subscriptions.getFuseSourceDirectory();
        fuseDir.mkdirs();
        if (!fuseDir.exists() || !fuseDir.isDirectory()) {
            throw new CouldNotCreateDirectoryException(fuseDir);
        }
        File outFile = new File(fuseDir, LICENSE_FILE);
        if (outFile.exists()) {
            File newFile = null;
            while ((newFile = new File(fuseDir, LICENSE_FILE + timestampFormat.format(new Date()))).exists()) {
                try {
                    Thread.sleep(Math.round(2000.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!outFile.renameTo(newFile)) {
                throw new CannotRenameFileException(outFile, newFile);
            }
        }
        IOUtil.writeText((File)outFile, (String)license);
    }

    public static File getFuseSourceDirectory() {
        File homeDir = new File(System.getProperty("user.home", "."));
        Activator.getLogger().debug("Home dir is: " + homeDir);
        File fuseDir = new File(homeDir, FUSESOURCE_DIR);
        return fuseDir;
    }

    public static boolean installLicenseFile(String path) {
        Activator.getLogger().debug("Attempting to manually install the subscription file " + path);
        String license = null;
        license = IOUtil.loadTextFile((File)new File(path), (String)Charset.defaultCharset().name());
        if (license == null) {
            Activator.getLogger().error("Unable to read the FuseSource license file " + path);
            return false;
        }
        File fuseDir = Subscriptions.getFuseSourceDirectory();
        fuseDir.mkdirs();
        if (!fuseDir.exists() || !fuseDir.isDirectory()) {
            Activator.getLogger().error("Unable to create the FuseSource license folder " + fuseDir.getPath());
            return false;
        }
        File outFile = new File(fuseDir, LICENSE_FILE);
        if (outFile.exists()) {
            File newFile = null;
            while ((newFile = new File(fuseDir, LICENSE_FILE + timestampFormat.format(new Date()))).exists()) {
                try {
                    Thread.sleep(Math.round(2000.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!outFile.renameTo(newFile)) {
                Activator.getLogger().error("Unable to backup the old license file. Aborting...");
                return false;
            }
        }
        IOUtil.writeText((File)outFile, (String)license);
        return true;
    }

    public static Subscriptions parse(String text) {
        String userName = null;
        Date devExpiryDate = null;
        Date prodExpiryDate = null;
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(text));
            userName = properties.getProperty("u");
            prodExpiryDate = Subscriptions.date(properties.getProperty("prod"));
            devExpiryDate = Subscriptions.date(properties.getProperty("dev"));
        }
        catch (Exception e) {
            Activator.getLogger().warning("Error loading license: " + text + ". Reason: " + e, (Throwable)e);
        }
        return new Subscriptions(userName, devExpiryDate, prodExpiryDate, properties);
    }

    private static Date date(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        return dateFormat.parse(value);
    }

    public Subscriptions() {
        this.properties = new Properties();
    }

    public Subscriptions(String userName) {
        this();
        this.userName = userName;
    }

    public Subscriptions(String userName, Date devExpiryDate, Date prodExpiryDate, Properties properties) {
        this.userName = userName;
        this.devExpiryDate = devExpiryDate;
        this.prodExpiryDate = prodExpiryDate;
        this.properties = properties;
    }

    public String toString() {
        return "Subscription(" + this.userName + (this.devExpiryDate != null ? "[DEV:" + dateFormat.format(this.devExpiryDate) + "]" : "") + (this.prodExpiryDate != null ? "[PROD:" + dateFormat.format(this.prodExpiryDate) + "]" : "") + ")";
    }

    public LicenseStatus getDevStatus() {
        return this.status(this.getDevExpiryDate());
    }

    public LicenseStatus getProdStatus() {
        return this.status(this.prodExpiryDate);
    }

    public boolean isDevValid() {
        return Subscriptions.isValid(this.getDevExpiryDate());
    }

    public boolean isProdValid() {
        return Subscriptions.isValid(this.prodExpiryDate);
    }

    public boolean isDevSubscriber() {
        return this.getDevExpiryDate() != null;
    }

    public boolean isProdSubscriber() {
        return this.prodExpiryDate != null;
    }

    public Date getDevExpiryDate() {
        if (this.devExpiryDate == null) {
            return this.prodExpiryDate;
        }
        return this.devExpiryDate;
    }

    public void setDevExpiryDate(Date devExpiryDate) {
        this.devExpiryDate = devExpiryDate;
    }

    public Date getProdExpiryDate() {
        return this.prodExpiryDate;
    }

    public void setProdExpiryDate(Date prodExpiryDate) {
        this.prodExpiryDate = prodExpiryDate;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected static boolean isValid(Date expiryDate) {
        if (expiryDate != null) {
            Date dayAfter = new Date(expiryDate.getTime() + 86400000L - 60000L);
            Date now = new Date();
            return now.before(dayAfter);
        }
        return false;
    }

    protected LicenseStatus status(Date date) {
        if (date == null) {
            return LicenseStatus.None;
        }
        if (Subscriptions.isValid(date)) {
            long delta = date.getTime() - new Date().getTime();
            if (delta < 604800000L) {
                return LicenseStatus.ExpiresSoon;
            }
            return LicenseStatus.Valid;
        }
        return LicenseStatus.Expired;
    }
}

