/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus.dialog;

import com.fusesource.rider.sus.Activator;
import com.fusesource.rider.sus.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public abstract class SubscriptionDialogSupport
extends Dialog {
    private final String subscriptionName;

    public SubscriptionDialogSupport(Shell parentShell, String subscriptionName) {
        super(parentShell);
        this.subscriptionName = subscriptionName;
        this.setShellStyle(67680);
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    protected Link createSubscriptionPreferencesLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setText(text);
        link.setLayoutData((Object)new GridData(64, 4, true, true, 3, 3));
        link.addSelectionListener((SelectionListener)this.createOpenSubscriptionPreferencesListener());
        return link;
    }

    protected SelectionAdapter createOpenSubscriptionPreferencesListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog createPreferenceDialogOn = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)"com.fusesource.rider.preferences.subscription.page", null, null);
                createPreferenceDialogOn.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button fuseSource = this.createButton(parent, 10, Messages.openFuseSourceButtonLabel, false);
        fuseSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubscriptionDialogSupport.this.openLink("http://fusesource.com/enterprise-support/support-offerings/");
            }
        });
        Button preferencesButton = this.createButton(parent, 0, Messages.openSubscriptionPreferencesButtonLabel, false);
        preferencesButton.addSelectionListener((SelectionListener)this.createOpenSubscriptionPreferencesListener());
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Label createLabel(Composite composite, String text) {
        Label label = new Label(composite, 524288);
        label.setText(text);
        return label;
    }

    protected FormText createFormText(Composite composite, String text) {
        FormText formText = new FormText(composite, 524288);
        formText.setText(text, true, true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                Object link = event.getHref();
                if (link != null) {
                    SubscriptionDialogSupport.this.openLink(link.toString());
                }
            }
        });
        return formText;
    }

    protected void openLink(String linkUrl) {
        URL url;
        try {
            url = new URL(linkUrl);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        IWebBrowser browser = null;
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            browser = support.createBrowser("FuseSource.com");
        }
        catch (PartInitException e) {
            Activator.getLogger().warning("Could not create browser: " + (Object)((Object)e), (Throwable)e);
        }
        if (browser != null && url != null) {
            try {
                browser.openURL(url);
                this.close();
            }
            catch (Exception e) {
                Activator.getLogger().warning("Could not open browser at " + url + ". " + e, (Throwable)e);
            }
        }
    }
}

