/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus.preferences;

import com.fusesource.rider.preferences.PreferenceManager;
import com.fusesource.rider.sus.Activator;
import com.fusesource.rider.sus.Messages;
import com.fusesource.rider.sus.Subscriptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class SubscriptionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DateFormat dateFormat = DateFormat.getDateInstance(1);
    private Label lbl_name;
    private Label lbl_pass;
    private Label lbl_expd;
    private Text txt_name;
    private Text txt_pass;
    private Text txt_expd;
    private Text txt_stat;
    private Link link;
    private Button btn_validate;
    private Button btn_installLicFile;
    private Date expiryDate;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.applyDialogFont(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.fusesource.rider.editor.subscribe");
        this.link = new Link(composite, 64);
        this.link.setLayoutData((Object)new GridData(768));
        String blueText = String.format("<a>%s</a>", Messages.linkBlueLabelPart);
        String text = NLS.bind((String)Messages.linkToFuseSourceLabel, (Object)blueText);
        this.link.setText(text);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URL url = null;
                try {
                    url = new URL("http://fusesource.com/enterprise-support/support-offerings/");
                }
                catch (MalformedURLException malformedURLException) {
                    url = null;
                }
                IWebBrowser browser = null;
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    browser = support.createBrowser("FuseSource.com");
                }
                catch (PartInitException ex) {
                    ex.printStackTrace();
                }
                if (browser != null && url != null) {
                    try {
                        browser.openURL(url);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite c2 = new Composite(composite, 0);
        c2.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        c2.setLayout((Layout)layout);
        this.lbl_name = new Label(c2, 0);
        this.lbl_name.setText(Messages.subscriberName);
        this.lbl_name.setLayoutData((Object)new GridData(768));
        this.txt_name = new Text(c2, 2048);
        this.txt_name.setLayoutData((Object)new GridData(768));
        Composite c3 = new Composite(composite, 0);
        c3.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        c3.setLayout((Layout)layout);
        this.lbl_pass = new Label(c3, 0);
        this.lbl_pass.setText(Messages.subscriberPassword);
        this.lbl_pass.setLayoutData((Object)new GridData(768));
        this.txt_pass = new Text(c3, 2048);
        this.txt_pass.setLayoutData((Object)new GridData(768));
        this.txt_pass.setEchoChar('*');
        Composite c4 = new Composite(composite, 0);
        c4.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        c4.setLayout((Layout)layout);
        this.lbl_expd = new Label(c4, 0);
        this.lbl_expd.setText(Messages.subscriberExpDate);
        this.lbl_expd.setLayoutData((Object)new GridData(768));
        this.txt_expd = new Text(c4, 0x1000800);
        this.txt_expd.setLayoutData((Object)new GridData(768));
        this.txt_expd.setEditable(false);
        this.txt_expd.setEnabled(false);
        this.txt_stat = new Text(composite, 2048);
        this.txt_stat.setLayoutData((Object)new GridData(768));
        this.txt_stat.setEnabled(false);
        this.txt_stat.setEditable(false);
        this.txt_stat.setVisible(false);
        this.btn_validate = new Button(composite, 8);
        this.btn_validate.setLayoutData((Object)new GridData(768));
        this.btn_validate.setText(Messages.downloadLicenseLabel);
        this.btn_validate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SubscriptionPreferencePage.this.downloadLicense();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.btn_installLicFile = new Button(composite, 8);
        this.btn_installLicFile.setLayoutData((Object)new GridData(768));
        this.btn_installLicFile.setText(Messages.installLicenseLabel);
        this.btn_installLicFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SubscriptionPreferencePage.this.installLicenseFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.initializeFields();
        return composite;
    }

    private void initializeFields() {
        this.txt_name.setText(PreferenceManager.getInstance().loadPreferenceAsString("fuse.subscriber.name"));
        this.txt_pass.setText(PreferenceManager.getInstance().loadPreferenceAsString("fuse.subscriber.pass"));
        this.showSubscriptionSummary(false);
    }

    private void installLicenseFile() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        dlg.setFileName("license.key");
        dlg.setFilterExtensions(new String[]{"*.key", "*.*"});
        dlg.setFilterNames(new String[]{"Fuse IDE License", "All Files"});
        dlg.setText(Messages.installLicenseFileDialogText);
        String path = dlg.open();
        if (path != null) {
            if (Subscriptions.installLicenseFile(path) && this.showSubscriptionSummary(true)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.licenseInstalledTitle, (String)Messages.licenseInstalledText);
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.licenseNotInstalledTitle, (String)Messages.licenseNotInstalledText);
            }
        }
    }

    private void downloadLicense() {
        try {
            String userName = this.txt_name.getText();
            String password = this.txt_pass.getText();
            Subscriptions.downloadLicense(userName, password);
            if (!this.showSubscriptionSummary(true)) {
                throw new Exception("Invalid Fuse IDE key file!");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setErrorMessage(ex.getMessage());
            this.txt_stat.setText("EVALUATION");
        }
    }

    protected boolean showSubscriptionSummary(boolean showMessage) {
        try {
            Subscriptions subscriptions = Subscriptions.load();
            Date date = subscriptions.getDevExpiryDate();
            if (date != null) {
                this.txt_expd.setText(this.dateFormat.format(date));
            } else {
                this.txt_expd.setText("");
            }
            switch (subscriptions.getDevStatus()) {
                case Valid: 
                case ExpiresSoon: {
                    this.setErrorMessage(null);
                    if (showMessage) {
                        this.setMessage("Subscription is valid and active.");
                    }
                    this.txt_stat.setText("REGISTERED");
                    break;
                }
                case Expired: {
                    if (showMessage) {
                        this.setErrorMessage("The subscription expired. Please contact FuseSource for a renewal!");
                    }
                    this.txt_stat.setText("EVALUATION");
                    break;
                }
                default: {
                    if (showMessage) {
                        this.setErrorMessage("No subscription available.");
                    }
                    this.txt_stat.setText("EVALUATION");
                    break;
                }
            }
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to load license file: " + e, (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean performOk() {
        PreferenceManager.getInstance().savePreference("fuse.subscriber.name", this.txt_name.getText());
        PreferenceManager.getInstance().savePreference("fuse.subscriber.pass", this.txt_pass.getText());
        PreferenceManager.getInstance().savePreference("fuse.subscriber.expdate", this.txt_expd.getText());
        PreferenceManager.getInstance().savePreference("fuse.subscriber.state", this.txt_stat.getText());
        return super.performOk();
    }

    protected void performApply() {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.subscriptionPageDescription);
    }
}

