/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.sus.util;

import com.fusesource.rider.commons.logging.RiderLogFacade;
import com.fusesource.rider.sus.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.fusesource.scalate.util.IOUtil;
import org.osgi.framework.Bundle;

public class Decrypt {
    private RiderLogFacade logger = Activator.getLogger();

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("mvn exec:java -Dexec.mainClass=com.fusesource.license.Decrypt -Dexec.args=\"license.key\"");
            System.out.println("where:    arg[0]=license.key sample user license key file");
            System.exit(1);
        }
        try {
            new Decrypt().doIt(args);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Decrypt() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public String decrypt(InputStream licenseFileStream) throws Exception {
        String fileName = "keys/rsa_public.der";
        Bundle bundle = Activator.getDefault().getBundle();
        InputStream publicKeyStream = null;
        URL resource = null;
        if (bundle != null) {
            resource = bundle.getResource(fileName);
        }
        if (resource == null) {
            resource = Thread.currentThread().getContextClassLoader().getResource(fileName);
            if (resource == null) {
                resource = this.getClass().getClassLoader().getResource(fileName);
            }
            if (resource == null) {
                String fullName = "com.fusesource.rider.sus/" + fileName;
                File file = new File(fullName);
                if (!file.exists()) {
                    file = new File("../" + fullName);
                }
                publicKeyStream = new FileInputStream(file);
            }
        }
        if (publicKeyStream == null) {
            if (resource == null) {
                throw new Exception("Could not find rsa_public.der inside bundle!");
            }
            publicKeyStream = resource.openStream();
        }
        return this.decrypt(licenseFileStream, publicKeyStream);
    }

    public String decrypt(InputStream licenseFileStream, InputStream publicKeyStream) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] encodedKey = this.readBytes(publicKeyStream);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        byte[] license = this.readBytes(licenseFileStream);
        byte[] decoded = Base64.decodeBase64((byte[])license);
        return this.decrypt(decoded, publicKey);
    }

    protected byte[] readBytes(InputStream stream) throws IOException {
        return IOUtil.loadBytes((InputStream)stream);
    }

    protected String doIt(String[] args) throws Exception {
        FileInputStream publicKeyStream = new FileInputStream(args[1]);
        FileInputStream licenseFileStream = new FileInputStream(args[0]);
        return this.decrypt(licenseFileStream, publicKeyStream);
    }

    private String decrypt(byte[] in, PublicKey key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        cipher.init(2, key);
        byte[] decrypted = null;
        decrypted = cipher.doFinal(in);
        String result = new String(decrypted);
        this.logger.debug("decrypt() output is " + result);
        return result;
    }
}

